/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.detectors;

import java.awt.Color;
import java.io.Serializable;
import java.util.Set;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.devices.detectors.APointDetector;
import pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.legacy_2012_1.domain.geom.FreePointLoc;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.util.Util;

public class SprinklerLink
extends APointDetector
implements IDirectDependent,
Serializable {
    static final long serialVersionUID = 1L;
    private SprinklerLinkModel d_linkDesc;
    private static final IPrimProps s_primProps = new IPrimProps.Vertex(Color.GREEN, 10.0);

    public SprinklerLink(String name, SprinklerLinkModel desc, FreePointLoc loc) {
        super(name, loc);
        this.d_linkDesc = desc;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SprinklerLink && super.equals(obj) && this.d_linkDesc.equals(((SprinklerLink)obj).d_linkDesc);
    }

    public SprinklerLinkModel getModel() {
        return this.d_linkDesc;
    }

    public void setModel(SprinklerLinkModel link) {
        this.d_linkDesc = link;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        assert (this.d_linkDesc != null) : "A sprinkler link must have a link description";
        deps.add(DLink.STRONG, (IPyroObject)this.d_linkDesc);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        Util.removeAllNotOfType(objs, SprinklerLinkModel.class);
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (old == this.getModel()) {
            assert (replacement != null);
            return new AReplaceRefTask<SprinklerLinkModel>((Object)old, (Object)replacement){

                @Override
                public void set(SprinklerLinkModel obj) {
                    SprinklerLink.this.setModel(obj);
                }
            };
        }
        return null;
    }

    @Override
    protected IPrimProps getPrimProps() {
        return s_primProps;
    }
}

