/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.detectors;

import java.awt.Color;
import java.io.Serializable;
import java.util.Set;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.domain.devices.detectors.APointDetector;
import pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModel;
import pyrosim.legacy_2012_1.domain.geom.FreePointLoc;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPrimProps;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.util.Util;

public class SmokeDetector
extends APointDetector
implements IDirectDependent,
Serializable {
    static final long serialVersionUID = 1L;
    private SmokeLinkModel d_model;
    private static final IPrimProps s_primProps = new IPrimProps.Vertex(Color.GREEN, 10.0);

    public SmokeDetector(String name, SmokeLinkModel model) {
        this(name, model, new FreePointLoc());
    }

    public SmokeDetector(String name, SmokeLinkModel model, FreePointLoc loc) {
        super(name, loc);
        this.d_model = model;
    }

    @Override
    public boolean isMixFracOnly() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SmokeDetector && super.equals(obj) && this.d_model.equals(((SmokeDetector)obj).d_model);
    }

    public SmokeLinkModel getModel() {
        return this.d_model;
    }

    public void setModel(SmokeLinkModel model) {
        assert (this.d_model != null);
        this.d_model = model;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        assert (this.d_model != null) : "A SmokeDetector must have a model";
        deps.add(DLink.STRONG, (IPyroObject)this.d_model);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        Util.removeAllNotOfType(objs, SmokeLinkModel.class);
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (old == this.d_model) {
            assert (replacement != null);
            return new AReplaceRefTask<SmokeLinkModel>((Object)old, (Object)replacement){

                @Override
                public void set(SmokeLinkModel obj) {
                    SmokeDetector.this.setModel(obj);
                }
            };
        }
        return null;
    }

    @Override
    protected IPrimProps getPrimProps() {
        return s_primProps;
    }
}

