/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices.detectors;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.domain.devices.APointSrcDevc;
import pyrosim.legacy_2012_1.domain.devices.TripFlags;
import pyrosim.legacy_2012_1.domain.devices.detectors.IDetector;
import pyrosim.legacy_2012_1.domain.geom.FreePointLoc;
import pyrosim.legacy_2012_1.domain.signals.ILatchable;
import pyrosim.legacy_2012_1.domain.signals.ILogicOutPin;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.domain.signals.LogicOutPin;
import pyrosim.legacy_2012_1.io.PyroSimObjectInputStream;

public abstract class APointDetector
extends APointSrcDevc
implements IDetector,
Serializable,
ILatchable {
    static final long serialVersionUID = 1L;
    private LogicOutPin d_alarmPin = new LogicOutPin(this, Intl.intl("ALARM"));
    private int d_tripFlags = 1;

    public APointDetector(String name, FreePointLoc loc) {
        super(name, loc);
    }

    @Override
    public boolean latches(ILogicOutPin pin) {
        return TripFlags.latch(this.d_tripFlags);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (stream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)stream).getVersion() < 29) {
            this.d_tripFlags = 0;
        }
    }

    @Override
    public Object clone() {
        APointDetector clone = (APointDetector)super.clone();
        clone.d_alarmPin = (LogicOutPin)this.d_alarmPin.clone(clone);
        return clone;
    }

    @Override
    public void setTripFlags(int tf) {
        this.d_tripFlags = tf;
        this.changedEvt(new Object[0]);
    }

    @Override
    public int getTripFlags() {
        return this.d_tripFlags;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof APointDetector && super.equals(obj) && ((APointDetector)obj).d_tripFlags == this.d_tripFlags;
    }

    @Override
    public List<? extends IOutPin> getOutputPins() {
        return Arrays.asList(this.d_alarmPin);
    }
}

