/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.devices;

import java.util.Arrays;
import java.util.Collection;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import pyrosim.legacy_2012_1.ILegacy_2012_1;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.domain.geom.FreePointLoc;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.manip.IHandle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IPointOptimizer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.TransformedGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.IIsectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.picking.ISnapConstraint;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.objs.Point;

public class FreePointGeom
extends TransformedGeom {
    private static final long serialVersionUID = 5195100017311796148L;
    public final FreePointLoc loc;

    public FreePointGeom(FreePointLoc loc, IGeom geom) {
        super(loc.toTransform(), geom);
        this.loc = loc;
    }

    @Override
    public pyrosim.domain.devices.FreePointGeom fromLegacy(LegacyDictionary_2012_1 dict) {
        assert (dict.get(this.geom) instanceof Point && ((Point)dict.get((ILegacy_2012_1)this.geom)).loc.equals(GeomConstants.PNT3D_ORIGIN));
        return new pyrosim.domain.devices.FreePointGeom(this.loc.fromLegacy(dict));
    }

    @Override
    public FreePointGeom optimize(IPointOptimizer pool) {
        IGeom optimized = super.optimize(pool);
        if (optimized == this) {
            return this;
        }
        if (optimized instanceof TransformedGeom) {
            optimized = ((TransformedGeom)optimized).geom;
        }
        return new FreePointGeom(this.loc, optimized);
    }

    @Override
    public FreePointGeom collapse() {
        TransformedGeom collapsed = super.collapse();
        return collapsed == this ? this : new FreePointGeom(this.loc, collapsed.geom);
    }

    @Override
    public IGeom transform(Matrix4d xform, IGeom.XformOp op) {
        FreePointLoc newLoc = this.loc.transform(xform);
        return new FreePointGeom(newLoc, this.geom);
    }

    @Override
    public Collection<? extends IHandle> generateManipHandles() {
        return Arrays.asList(new Handle(this));
    }

    private static class Handle
    implements IHandle {
        private FreePointGeom d_geom;

        public Handle(FreePointGeom geom) {
            this.d_geom = geom;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Handle;
        }

        @Override
        public IGeom getGeom() {
            return new pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Point(this.d_geom.loc.d_location.getPoint3dValue(Geometry.LU));
        }

        @Override
        public IIsectFilter getPickFilter() {
            return null;
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            return null;
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
        }

        @Override
        public Object modify(Point3d newLoc) throws Exception {
            FreePointLoc newFreeLoc = new FreePointLoc(new UnitPoint3D(newLoc, Geometry.LU), this.d_geom.loc.d_orientation, this.d_geom.loc.d_rotation);
            this.d_geom = new FreePointGeom(newFreeLoc, this.d_geom.geom);
            return this.d_geom;
        }

        @Override
        public Object end() {
            return this.d_geom;
        }
    }
}

