/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.dependencies;

import java.util.Collection;
import java.util.Set;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DepSnapshot;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.thunderheadeng.util.ATask;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;

public class DepUtil {
    public static Task getReplacementTask(DepSnapshot deps, IDirectDependent dep, IPyroObject old, IPyroObject repl) {
        Task baseTask = dep.taskReplaceDep(old, repl);
        if (dep instanceof IPyroObject) {
            return baseTask;
        }
        Set<IPyroObject> domainParents = deps.getAncestors(IPyroObject.class, dep);
        return new ReplacementTask(baseTask, domainParents);
    }

    private static class ReplacementTask
    extends ATask {
        private final Task d_baseTask;
        private final IPyroObject[] d_domainParents;

        public ReplacementTask(Task baseTask, Collection<? extends IPyroObject> domainParents) {
            this.d_baseTask = baseTask;
            this.d_domainParents = domainParents.toArray(new IPyroObject[domainParents.size()]);
        }

        @Override
        public boolean canUndo() {
            return this.d_baseTask.canUndo();
        }

        @Override
        public void run() {
            this.pauseEvts();
            this.d_baseTask.run();
            this.fireEvts();
            this.resumeEvts();
        }

        @Override
        public void undo() {
            this.pauseEvts();
            this.d_baseTask.undo();
            this.fireEvts();
            this.resumeEvts();
        }

        private void pauseEvts() {
            PyroMod domain = this.domain();
            if (domain != null) {
                domain.pauseUpdates();
            }
        }

        private void resumeEvts() {
            PyroMod domain = this.domain();
            if (domain != null) {
                domain.resumeUpdates();
            }
        }

        private PyroMod domain() {
            return this.d_domainParents.length > 0 ? (PyroMod)this.d_domainParents[0].getDomain() : null;
        }

        private void fireEvts() {
            for (IPyroObject obj : this.d_domainParents) {
                obj.changedEvt(new Object[0]);
            }
        }
    }
}

