/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.controls;

import java.util.ArrayList;
import pyrosim.legacy_2012_1.domain.controls.ControlBridge;
import pyrosim.legacy_2012_1.domain.controls.IControl;
import pyrosim.legacy_2012_1.domain.signals.IInPin;
import pyrosim.legacy_2012_1.domain.signals.ILogicOutPin;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.domain.signals.ISignalSink;
import pyrosim.legacy_2012_1.domain.signals.ISignalSource;

public class Util {
    public static boolean deleteNoops(IInPin inPin) {
        if (inPin == null) {
            return false;
        }
        boolean modified = false;
        ArrayList<? extends IOutPin> currOutPins = new ArrayList<IOutPin>(inPin.getConnections());
        block0: for (IOutPin iOutPin : currOutPins) {
            IControl ctrl;
            if (iOutPin.getAttachedSource() instanceof ISignalSink) {
                ISignalSink sink = (ISignalSink)((Object)iOutPin.getAttachedSource());
                modified |= Util.deleteNoops(sink.getInputPin());
            }
            if (!(iOutPin.getAttachedSource() instanceof IControl) || !(ctrl = (IControl)iOutPin.getAttachedSource()).isNoop() || ctrl instanceof ControlBridge) continue;
            modified = true;
            inPin.disconnect(iOutPin);
            for (IOutPin iOutPin2 : ctrl.getInputPin().getConnections()) {
                if (!inPin.isCompatible(iOutPin2)) continue;
                inPin.connect(iOutPin2);
                continue block0;
            }
        }
        return modified;
    }

    public static boolean isNoop(IOutPin pin) {
        ISignalSource src = pin.getAttachedSource();
        return src instanceof IControl && ((IControl)src).isNoop();
    }

    public static int countNumValidInputs(IInPin inPin) {
        int numValid = 0;
        for (IOutPin iOutPin : inPin.getConnections()) {
            if (Util.isNoop(iOutPin)) continue;
            ++numValid;
        }
        return numValid;
    }

    public static boolean inputLatches(IInPin inPin) {
        for (IOutPin iOutPin : inPin.getConnections()) {
            if (!(iOutPin instanceof ILogicOutPin)) continue;
            return ((ILogicOutPin)iOutPin).latches();
        }
        return false;
    }
}

