/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.boundcond.surf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Material;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Backing;
import pyrosim.legacy_2012_1.domain.dependencies.DLink;
import pyrosim.legacy_2012_1.domain.dependencies.DepList;
import pyrosim.legacy_2012_1.domain.dependencies.IDirectDependent;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashMap;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.util.Util;

public class SurfComposition
implements Serializable {
    static final long serialVersionUID = 1L;
    public final UnitDouble d_initInnerTemp;
    public final TimeFunction d_tempRamp;
    public final List<SurfLayer> d_layers;
    public final Backing d_backing;
    public final boolean d_porous;
    public final Double d_layerDivide;

    public SurfComposition() {
        this(null, TimeFunction.newDefault(), Backing.newDefault(), false, null, new ArrayList<SurfLayer>(0));
    }

    public SurfComposition(UnitDouble initialInnerTemp, TimeFunction tempRamp, Backing backing, boolean porous, Double layerDivide, List<SurfLayer> layers) {
        this.d_initInnerTemp = initialInnerTemp;
        this.d_tempRamp = tempRamp;
        this.d_backing = backing;
        this.d_porous = porous;
        this.d_layerDivide = layerDivide;
        this.d_layers = Collections.unmodifiableList(layers);
        assert (this.d_layerDivide == null || this.d_layerDivide <= (double)this.d_layers.size() && this.d_layerDivide >= 0.0);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SurfComposition)) {
            return false;
        }
        SurfComposition comp = (SurfComposition)obj;
        return this.d_porous == comp.d_porous && this.d_backing.equals(comp.d_backing) && theUtil.equal(this.d_layerDivide, comp.d_layerDivide) && theUtil.equal(this.d_initInnerTemp, comp.d_initInnerTemp) && this.d_tempRamp.equals(comp.d_tempRamp) && this.d_layers.equals(comp.d_layers);
    }

    public static class SurfLayer
    implements IDirectDependent,
    Serializable {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_thickness;
        private final Map<Material, SurfComponent> d_components;

        public SurfLayer(UnitDouble thickness, Collection<SurfComponent> comps) {
            this.d_thickness = thickness;
            this.d_components = new LinkedIdentityHashMap<Material, SurfComponent>();
            for (SurfComponent comp : comps) {
                this.d_components.put(comp.d_material, comp);
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SurfLayer)) {
                return false;
            }
            SurfLayer layer = (SurfLayer)obj;
            return this.d_thickness.equals(layer.d_thickness) && Util.identityMapsEqual(this.d_components, layer.d_components);
        }

        public Collection<SurfComponent> getComponents() {
            return this.d_components.values();
        }

        @Override
        public void takeDepSnapshot(DepList deps) {
            deps.add(DLink.REQUIRED, this.d_components.keySet());
        }

        @Override
        public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
            Util.removeAllNotOfType(objs, Material.class);
        }

        @Override
        public Task taskReplaceDep(final IPyroObject old, final IPyroObject replacement) {
            if (!this.d_components.containsKey(old)) {
                return null;
            }
            return new AUndoableTask(){
                private Map<Material, SurfComponent> d_oldComp;

                @Override
                public void undo() {
                    d_components.clear();
                    d_components.putAll(this.d_oldComp);
                    this.d_oldComp = null;
                }

                @Override
                public void run() {
                    this.d_oldComp = new LinkedIdentityHashMap<Material, SurfComponent>(d_components);
                    SurfComponent oldComp = d_components.remove(old);
                    SurfComponent existingComp = d_components.get(replacement);
                    if (existingComp == null) {
                        SurfComponent newComp = new SurfComponent(oldComp.d_massFraction, (Material)replacement);
                        d_components.put((Material)replacement, newComp);
                    } else {
                        SurfComponent combinedComp = new SurfComponent(oldComp.d_massFraction + existingComp.d_massFraction, (Material)replacement);
                        d_components.put((Material)replacement, combinedComp);
                    }
                }
            };
        }

        public static class SurfComponent
        implements Serializable {
            static final long serialVersionUID = 1L;
            public final double d_massFraction;
            public final Material d_material;

            public SurfComponent(double massFraction, Material mat) {
                this.d_massFraction = massFraction;
                this.d_material = mat;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof SurfComponent)) {
                    return false;
                }
                SurfComponent comp = (SurfComponent)obj;
                return this.d_massFraction == comp.d_massFraction && this.d_material.equals(comp.d_material);
            }
        }
    }
}

