/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.boundcond.mat;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2012_1.domain.boundcond.mat.ReacByproducts;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Reaction;
import pyrosim.legacy_2012_1.io.PyroSimObjectInputStream;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import pyrosim.legacy_2012_1.util.Util;

public class SolidReaction
extends Reaction {
    static final long serialVersionUID = 1L;
    public final Rate d_rate;

    public SolidReaction() {
        this(new Rate(), new ReacByproducts());
    }

    public SolidReaction(Rate rate, ReacByproducts byproducts) {
        super(byproducts);
        this.d_rate = rate;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SolidReaction)) {
            return false;
        }
        SolidReaction reac = (SolidReaction)obj;
        return super.equals(obj) && this.d_rate.equals(reac.d_rate);
    }

    public static class Rate
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final double d_tempExponent;
        public final double d_massFracExponent;
        public final UnitDouble d_thresholdTemp;
        public final ISpecification d_spec;

        public Rate() {
            this(1.0, 0.0, new UnitDouble(-273.15, SI.CELSIUS), new RefSpec());
        }

        public Rate(double massFracExp, double tempExp, UnitDouble thresholdTemp, ISpecification spec) {
            this.d_tempExponent = tempExp;
            this.d_massFracExponent = massFracExp;
            this.d_thresholdTemp = thresholdTemp;
            this.d_spec = spec;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Rate)) {
                return false;
            }
            Rate r = (Rate)obj;
            return this.d_tempExponent == r.d_tempExponent && this.d_massFracExponent == r.d_massFracExponent && theUtil.equal(this.d_thresholdTemp, r.d_thresholdTemp) && this.d_spec.equals(r.d_spec);
        }

        public static class RefSpec
        implements ISpecification {
            static final long serialVersionUID = 1L;
            public final UnitDouble d_refTemp;
            public final UnitDouble d_pyrolysisRange;
            public final UnitDouble d_heatingRate;

            public RefSpec() {
                this(new UnitDouble(100.0, SI.CELSIUS), new UnitDouble(80.0, SI.CELSIUS), new UnitDouble(5.0, SI.KELVIN.divide(NonSI.MINUTE)));
            }

            public RefSpec(UnitDouble refTemp, UnitDouble pyrolysisRange, UnitDouble heatingRate) {
                this.d_refTemp = refTemp;
                this.d_pyrolysisRange = pyrolysisRange;
                this.d_heatingRate = heatingRate;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof RefSpec)) {
                    return false;
                }
                RefSpec spec = (RefSpec)obj;
                return this.d_refTemp.equals(spec.d_refTemp) && this.d_pyrolysisRange.equals(spec.d_pyrolysisRange) && this.d_heatingRate.equals(spec.d_heatingRate);
            }

            private Object readResolve() throws ObjectStreamException {
                UnitDouble range = this.d_pyrolysisRange;
                UnitDouble rate = this.d_heatingRate;
                if (range == null || rate == null) {
                    RefSpec defSpec = new RefSpec();
                    range = defSpec.d_pyrolysisRange;
                    rate = defSpec.d_heatingRate;
                }
                return new RefSpec(this.d_refTemp, range, rate);
            }
        }

        public static interface ISpecification
        extends Serializable {
        }

        public static class AESpec
        implements ISpecification {
            static final long serialVersionUID = 1L;
            public final UnitDouble d_a;
            public final UnitDouble d_e;

            public AESpec() {
                this(SIUS.newud(1.0E13, 50), SIUS.newud(0.0, 54));
            }

            public AESpec(UnitDouble a, UnitDouble e) {
                this.d_a = a;
                this.d_e = e;
            }

            private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
                stream.defaultReadObject();
                if (stream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)stream).getVersion() < 34) {
                    double val = this.d_a.getValueNoUnit();
                    UnitDouble aNew = new UnitDouble(val, SIUS.unit(50));
                    try {
                        Util.assignFinalField(this, "d_a", aNew);
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof AESpec)) {
                    return false;
                }
                AESpec spec = (AESpec)obj;
                return this.d_a.equals(spec.d_a) && this.d_e.equals(spec.d_e);
            }
        }
    }
}

