/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.boundcond.mat;

import java.io.Serializable;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2012_1.domain.boundcond.mat.ReacByproducts;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Reaction;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class LiquidReaction
extends Reaction {
    static final long serialVersionUID = 1L;
    public final Rate d_rate;

    public LiquidReaction() {
        this(new Rate(), new ReacByproducts(0.0, 0.0, 0.0, null, SIUS.newud(0.0, 46)));
    }

    public LiquidReaction(Rate rate, ReacByproducts byproducts) {
        super(byproducts);
        assert (byproducts.d_heat != null);
        this.d_rate = rate;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof LiquidReaction)) {
            return false;
        }
        LiquidReaction lr = (LiquidReaction)obj;
        return super.equals(obj) && this.d_rate.equals(lr.d_rate);
    }

    public static class Rate
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_boilingTemp;

        public Rate() {
            this(new UnitDouble(100.0, SI.CELSIUS));
        }

        public Rate(UnitDouble boilingTemp) {
            this.d_boilingTemp = boilingTemp;
        }

        public boolean equals(Object obj) {
            return obj instanceof Rate && this.d_boilingTemp.equals(((Rate)obj).d_boilingTemp);
        }
    }
}

