/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain.boundcond.mat;

import java.io.ObjectStreamException;
import java.util.Arrays;
import java.util.Collection;
import pyrosim.legacy_2012_1.domain.boundcond.mat.IPyrolysis;
import pyrosim.legacy_2012_1.domain.boundcond.mat.LiquidReaction;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class LiquidPyrolysis
implements IPyrolysis {
    static final long serialVersionUID = 1L;
    public final UnitDouble d_heatOfCombust;
    public final UnitDouble d_iniVaporFlux;
    public final LiquidReaction d_reaction;

    public LiquidPyrolysis() {
        this(null, SIUS.newud(5.0E-4, 73), new LiquidReaction());
    }

    public LiquidPyrolysis(UnitDouble heatOfCombust, UnitDouble iniVaporFlux, LiquidReaction reac) {
        this.d_heatOfCombust = heatOfCombust;
        this.d_iniVaporFlux = iniVaporFlux;
        this.d_reaction = reac;
    }

    public boolean equals(Object obj) {
        return obj instanceof LiquidPyrolysis && theUtil.equal(this.d_heatOfCombust, ((LiquidPyrolysis)obj).d_heatOfCombust) && this.d_iniVaporFlux.equals(((LiquidPyrolysis)obj).d_iniVaporFlux) && this.d_reaction.equals(((LiquidPyrolysis)obj).d_reaction);
    }

    private Object readResolve() throws ObjectStreamException {
        UnitDouble vaporFlux = this.d_iniVaporFlux == null ? SIUS.newud(5.0E-4, 73) : this.d_iniVaporFlux;
        return new LiquidPyrolysis(this.d_heatOfCombust, vaporFlux, this.d_reaction);
    }

    public Collection<LiquidReaction> getReactions() {
        return Arrays.asList(this.d_reaction);
    }
}

