/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import pyrosim.legacy_2012_1.domain.ExSpecList;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.io.PyroSimObjectInputStream;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.unitsystem.SIUS;

public class ExSpec
extends NamedPyroObject
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    public static final int ID_NONE = 0;
    public static final int DNS_NONE = 0;
    public static final int DNS_LJ = 1;
    public static final int DNS_ALT = 2;
    private int d_id;
    private String d_fyi;
    private boolean d_isPredefined;
    private double d_massFrac0;
    private UnitDouble d_molWt;
    private boolean d_absorb;
    private int d_dnsType;
    private UnitDouble d_sigma;
    private UnitDouble d_epsilonK;
    private UnitDouble d_visc;
    private UnitDouble d_con;
    private UnitDouble d_diff;
    private UnitDouble d_massExtCoeff;

    public ExSpec(String name, boolean isPredefined) {
        this(name, isPredefined, 0);
    }

    protected ExSpec(String name, boolean isPredefined, int id) {
        super(name);
        SIUS uSys = SIUS.getInstance();
        this.d_id = id;
        this.d_isPredefined = isPredefined;
        this.d_massFrac0 = 0.0;
        this.d_molWt = new UnitDouble(29.0, uSys.getMolecularWeightUnit());
        this.d_absorb = false;
        this.d_dnsType = 0;
        this.d_sigma = new UnitDouble(0.0, uSys.getLJSigmaUnit());
        this.d_epsilonK = new UnitDouble(0.0, uSys.getLJEpsilonKUnit());
        this.d_visc = new UnitDouble(0.0, uSys.getViscosityUnit());
        this.d_con = new UnitDouble(0.0, uSys.getConductivityUnit());
        this.d_diff = new UnitDouble(0.0, uSys.getDiffusionUnit());
        this.d_massExtCoeff = null;
    }

    public ExSpec(int id) {
        this("", false, id);
    }

    public ExSpec(ExSpec original) {
        this.setName(original.getName());
        this.d_id = original.d_id;
        this.d_isPredefined = original.d_isPredefined;
        this.d_massFrac0 = original.d_massFrac0;
        this.d_molWt = original.d_molWt;
        this.d_absorb = original.d_absorb;
        this.d_dnsType = original.d_dnsType;
        this.d_sigma = original.d_sigma;
        this.d_epsilonK = original.d_epsilonK;
        this.d_visc = original.d_visc;
        this.d_con = original.d_con;
        this.d_diff = original.d_diff;
        this.d_massExtCoeff = original.d_massExtCoeff;
    }

    public int hashCode() {
        if (this.d_id == 0) {
            return super.hashCode();
        }
        return 2330621 + this.d_id;
    }

    @Override
    public boolean isMixFracOnly() {
        return this.d_id != 0;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (in instanceof PyroSimObjectInputStream) {
            int version = ((PyroSimObjectInputStream)in).getVersion();
            if (version < 28 && this.d_massExtCoeff != null && this.d_massExtCoeff.getValueNoUnit() == 0.0) {
                this.d_massExtCoeff = null;
            }
            if (version < 30) {
                this.d_id = 0;
            }
        }
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.d_id != 0) {
            for (ExSpec spec : ExSpecList.MIXFRAC_EXSPECS) {
                if (spec.d_id != this.d_id) continue;
                return spec;
            }
        }
        return this;
    }

    public String getFYI() {
        return this.d_fyi == null ? "" : this.d_fyi;
    }

    public void setFYI(String fyi) {
        this.d_fyi = fyi;
        this.changedEvt(new Object[0]);
    }

    @Override
    public Object clone() {
        return new ExSpec(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ExSpec)) {
            return false;
        }
        ExSpec spec = (ExSpec)obj;
        if (this.d_id != 0) {
            return spec.d_id == this.d_id;
        }
        return this.getName().equals(spec.getName()) && this.d_isPredefined == spec.d_isPredefined && this.d_massFrac0 == spec.d_massFrac0 && this.d_molWt.equals(spec.d_molWt) && this.d_absorb == spec.d_absorb && this.d_dnsType == spec.d_dnsType && this.d_sigma.equals(spec.d_sigma) && this.d_epsilonK.equals(spec.d_epsilonK) && this.d_visc.equals(spec.d_visc) && this.d_con.equals(spec.d_con) && this.d_diff.equals(spec.d_diff) && theUtil.equal(this.d_massExtCoeff, spec.d_massExtCoeff);
    }

    public int getID() {
        return this.d_id;
    }

    public ExSpecList.MixFrac getMFSpec() {
        if (this.d_id == 0) {
            return null;
        }
        for (ExSpecList.MixFrac mf : ExSpecList.MixFrac.values()) {
            if (mf.spec.getID() != this.d_id) continue;
            return mf;
        }
        return null;
    }

    @Override
    public String getName() {
        ExSpecList.MixFrac spec = this.getMFSpec();
        if (spec == null) {
            return super.getName();
        }
        return spec.name;
    }

    public boolean getAbsorb() {
        return this.d_absorb;
    }

    public void setAbsorb(boolean flag) {
        if (this.d_absorb != flag) {
            this.d_absorb = flag;
            this.changedEvt(new Object[0]);
        }
    }

    public UnitDouble getConductivity() {
        return this.d_con;
    }

    public UnitDouble getDiffusivity() {
        return this.d_diff;
    }

    public UnitDouble getEpsilonK() {
        return this.d_epsilonK;
    }

    public boolean isPredefined() {
        return this.d_isPredefined;
    }

    public double getMassFrac0() {
        return this.d_massFrac0;
    }

    public UnitDouble getMolWt() {
        return this.d_molWt;
    }

    public UnitDouble getSigma() {
        return this.d_sigma;
    }

    public UnitDouble getViscosity() {
        return this.d_visc;
    }

    public int getDNSType() {
        return this.d_dnsType;
    }

    public void setMassFraction0(double mf0) {
        this.d_massFrac0 = mf0;
        this.changedEvt(new Object[0]);
    }

    public void setMolWt(UnitDouble molWt) {
        this.d_molWt = molWt;
        this.changedEvt(new Object[0]);
    }

    public void setDNSNone() {
        this.d_dnsType = 0;
        this.changedEvt(new Object[0]);
    }

    public void setDNSLJ(UnitDouble sigma, UnitDouble epsilonK) {
        this.d_dnsType = 1;
        this.d_sigma = sigma;
        this.d_epsilonK = epsilonK;
        this.changedEvt(new Object[0]);
    }

    public void setDNSAlt(UnitDouble visc, UnitDouble con, UnitDouble diff) {
        this.d_dnsType = 2;
        this.d_visc = visc;
        this.d_con = con;
        this.d_diff = diff;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getMassExtinctionCoeff() {
        return this.d_massExtCoeff;
    }

    public void setMassExtinctionCoeff(UnitDouble newVal) {
        this.d_massExtCoeff = newVal;
        this.changedEvt(new Object[0]);
    }
}

