/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.GridList;
import pyrosim.legacy_2012_1.domain.Hierarchy;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Material;
import pyrosim.legacy_2012_1.domain.boundcond.mat.MaterialManager;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SurfaceManager;
import pyrosim.legacy_2012_1.domain.geom.FDSObject;
import pyrosim.legacy_2012_1.domain.geom.GenericGeomSrc;
import pyrosim.legacy_2012_1.domain.output.Isosurface;
import pyrosim.legacy_2012_1.domain.reaction.Reaction;
import pyrosim.legacy_2012_1.domain.reaction.ReactionList;
import pyrosim.legacy_2012_1.thunderheadeng.util.FilteredSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.TypeFilter;

public class PyroSimSelectionModel {
    private final Set<Object> d_selectionSet = new LinkedIdentityHashSet<Object>();
    private final PyroMod d_pyMod;

    public PyroSimSelectionModel(PyroMod pyMod) {
        this.d_pyMod = pyMod;
    }

    protected void pauseUpdates() {
        this.d_pyMod.pauseUpdates();
    }

    protected void resumeUpdates() {
        this.d_pyMod.resumeUpdates();
    }

    public void setSelection(Object ... objs) {
        this.setSelection(Arrays.asList(objs));
    }

    public void setSelection(Collection<?> objs) {
        this.pauseUpdates();
        this.clearSelection();
        this.selectAll(objs);
        this.resumeUpdates();
    }

    private <T> void fireHierarchySelEvt(T obj) {
        PyroMod md = obj instanceof IPyroObject ? (PyroMod)((IPyroObject)obj).getDomain() : this.d_pyMod;
        if (md != null) {
            md.getEvents().changed(obj, PyroMod.EVT_SEL);
            if (obj instanceof IPyroObject) {
                for (IPyroObject iPyroObject : ((IPyroObject)obj).getMembers()) {
                    this.fireHierarchySelEvt(iPyroObject);
                }
            }
        }
    }

    private <T> void deselectChildren(T obj) {
        if (obj instanceof IPyroObject) {
            for (IPyroObject iPyroObject : ((IPyroObject)obj).getMembers()) {
                this.d_selectionSet.remove(iPyroObject);
                this.deselectChildren(iPyroObject);
            }
        }
    }

    public <T> void select(T obj) {
        this.pauseUpdates();
        if (!this.isSelected(obj) && this.d_selectionSet.add(obj)) {
            this.deselectChildren(obj);
            this.fireHierarchySelEvt(obj);
        }
        this.resumeUpdates();
    }

    public <T> void select(T ... objs) {
        this.select((T)Arrays.asList(objs));
    }

    public <T> void selectAll(Collection<? extends T> objs) {
        this.pauseUpdates();
        for (T o : objs) {
            this.select(o);
        }
        this.resumeUpdates();
    }

    public <T> void deselect(T obj) {
        this.pauseUpdates();
        if (this.d_selectionSet.remove(obj)) {
            this.fireHierarchySelEvt(obj);
        }
        this.resumeUpdates();
    }

    public <T> void deselect(T ... objs) {
        this.deselect((T)Arrays.asList(objs));
    }

    public <T> void deselectAll(Collection<? extends T> objs) {
        this.pauseUpdates();
        for (T o : objs) {
            this.deselect(o);
        }
        this.resumeUpdates();
    }

    public void clearSelection() {
        ArrayList<Object> objs = new ArrayList<Object>(this.d_selectionSet);
        this.deselectAll(objs);
    }

    private boolean isHierarchySelected(Object o) {
        IPyroObject parent = o instanceof IPyroObject ? ((IPyroObject)o).getParent() : null;
        return parent != null ? this.isSelected(parent) : false;
    }

    public boolean isSelected(Object o) {
        if (o == null) {
            return this.isEmpty();
        }
        return this.d_selectionSet.contains(o) || this.isHierarchySelected(o);
    }

    private <T> void collectChildren(Collection<T> coll, T obj, Class<T> type) {
        coll.add(obj);
        if (obj instanceof IPyroObject) {
            for (IPyroObject iPyroObject : ((IPyroObject)obj).getMembers()) {
                if (!type.isInstance(iPyroObject)) continue;
                IPyroObject childObj = iPyroObject;
                this.collectChildren(coll, childObj, type);
            }
        }
    }

    public Set<?> getSelection() {
        return this.d_selectionSet;
    }

    public <T> FilteredSet<T> getSelected(Class<T> type) {
        return new FilteredSet<T>(this.d_selectionSet, type);
    }

    public <T> FilteredSet<T> getSelected(Class<? extends T> ... types) {
        TypeFilter<? extends T> filter = new TypeFilter<T>(types);
        return new FilteredSet<T>(this.d_selectionSet, Object.class, filter);
    }

    public <T> FilteredSet<T> getSelected(Class<T> type, IObjectFilter<T> filter) {
        return new FilteredSet<T>(this.d_selectionSet, type, filter);
    }

    public <T> Collection<T> flatten(Class<T> type) {
        return Hierarchy.flatten(this.d_selectionSet, type);
    }

    public <T> Collection<T> flatten(Class<T> type, IObjectFilter<T> filter) {
        return Hierarchy.flatten(this.d_selectionSet, type, filter);
    }

    public int getNum(Class type) {
        return this.getSelected((Class<T>)type).size();
    }

    public boolean isEmpty() {
        return this.d_selectionSet.isEmpty();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("PyroSimSelectionModel:" + this.hashCode() + " {\n");
        str.append("   Object.class         -->> " + this.getSelection().size() + "\n");
        str.append("   GridList.class       -->> " + this.getSelected((Class<T>)GridList.class).size() + "\n");
        str.append("   Grid.class           -->> " + this.getSelected((Class<T>)Grid.class).size() + "\n");
        str.append("   MaterialManager.class-->> " + this.getSelected((Class<T>)MaterialManager.class).size() + "\n");
        str.append("   Material.class       -->> " + this.getSelected((Class<T>)Material.class).size() + "\n");
        str.append("   SurfaceManager.class -->> " + this.getSelected((Class<T>)SurfaceManager.class).size() + "\n");
        str.append("   ISurface.class       -->> " + this.getSelected((Class<T>)Isosurface.class).size() + "\n");
        str.append("   ReactionList.class   -->> " + this.getSelected((Class<T>)ReactionList.class).size() + "\n");
        str.append("   Reaction.class       -->> " + this.getSelected((Class<T>)Reaction.class).size() + "\n");
        str.append("   GenericGeomSrc.class -->> " + this.getSelected((Class<T>)GenericGeomSrc.class).size() + "\n");
        str.append("   FDSObject.class      -->> " + this.getSelected((Class<T>)FDSObject.class).size() + "\n");
        str.append("}\n");
        return str.toString();
    }
}

