/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.util;

import java.io.File;
import java.lang.reflect.Array;
import java.util.Collection;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.Disposable;

public class theUtil {
    public static <T> Collection<T> cast(Collection<?> orig, Collection<T> result, Class<T> resultType) {
        for (Object o : orig) {
            result.add(resultType.cast(o));
        }
        return result;
    }

    public static Vector3d projectToPlane(Vector3d planeNormal, Vector3d point) {
        Vector3d projPoint = new Vector3d(point);
        double dist = planeNormal.dot(projPoint);
        Vector3d moveVec = new Vector3d(planeNormal);
        moveVec.scale(-dist);
        projPoint.add(moveVec);
        return projPoint;
    }

    public static double angleBetweenNPIToPPI(Vector3d axis, Vector3d ref, Vector3d vec) {
        double angle = ref.angle(vec);
        Vector3d cross = new Vector3d();
        cross.cross(ref, vec);
        double dot = cross.dot(axis);
        if (dot >= 0.0) {
            return angle;
        }
        return -angle;
    }

    public static double angleBetween0To2PI(Vector3d axis, Vector3d v1, Vector3d v2) {
        double anglePIPI = theUtil.angleBetweenNPIToPPI(axis, v1, v2);
        if (anglePIPI >= 0.0) {
            return anglePIPI;
        }
        return Math.PI * 2 + anglePIPI;
    }

    public static UnitDouble roundAngle(UnitDouble angle, UnitDouble nearestInc, Unit u) {
        double angleRad = angle.getValue(SI.RADIAN);
        double nearestIncRad = nearestInc.getValue(SI.RADIAN);
        long numRevs = Math.round(Math.PI * 2 / nearestIncRad);
        long mult = Math.round(Math.abs(angleRad) / nearestIncRad) % numRevs;
        if (angleRad < 0.0) {
            mult = -mult;
        }
        double nativeValue = nearestInc.getValueNoUnit() * (double)mult;
        double convertedValue = UnitDouble.convert(nativeValue, nearestInc.getUnit(), u);
        return new UnitDouble(convertedValue, u);
    }

    public static Point3d p4dTo3d(Point4d p) {
        double invw = 1.0 / p.w;
        return new Point3d(p.x * invw, p.y * invw, p.z * invw);
    }

    public static void acquire(Disposable obj) {
        if (obj != null) {
            obj.acquire();
        }
    }

    public static void acquire(Disposable[] objs) {
        if (objs != null) {
            for (int m = 0; m < objs.length; ++m) {
                if (objs[m] == null) continue;
                objs[m].acquire();
            }
        }
    }

    public static <T> void acquire(Collection<T> objs) {
        if (objs != null) {
            for (T obj : objs) {
                theUtil.acquire(obj);
            }
        }
    }

    public static void acquire(Object obj) {
        if (obj instanceof Disposable) {
            ((Disposable)obj).acquire();
        }
    }

    public static void acquire(Object[] objs) {
        if (objs != null) {
            for (int m = 0; m < objs.length; ++m) {
                if (!(objs[m] instanceof Disposable)) continue;
                ((Disposable)objs[m]).acquire();
            }
        }
    }

    public static void release(Disposable obj) {
        if (obj != null) {
            obj.release();
        }
    }

    public static void release(Disposable[] objs) {
        if (objs != null) {
            for (int m = 0; m < objs.length; ++m) {
                if (objs[m] == null) continue;
                objs[m].release();
            }
        }
    }

    public static <T> void release(Collection<T> objs) {
        if (objs != null) {
            for (T obj : objs) {
                theUtil.release(obj);
            }
        }
    }

    public static void release(Object obj) {
        if (obj instanceof Disposable) {
            ((Disposable)obj).release();
        }
    }

    public static void release(Object[] objs) {
        if (objs != null) {
            for (int m = 0; m < objs.length; ++m) {
                if (!(objs[m] instanceof Disposable)) continue;
                ((Disposable)objs[m]).release();
            }
        }
    }

    public static String getFileExtension(File f) {
        String name = f.getAbsolutePath();
        int extix = name.lastIndexOf(".");
        if (extix >= 0 && extix < name.length() - 1) {
            return name.substring(extix + 1);
        }
        return "";
    }

    public static int binarySearch(double[] a, double key, DoubleComparator comp) {
        return theUtil.binarySearch(a, key, 0, a.length - 1, comp);
    }

    private static int binarySearch(double[] a, double key, int low, int high, DoubleComparator comp) {
        while (low <= high) {
            int mid = low + high >> 1;
            double midVal = a[mid];
            int cmp = comp.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static <T extends Number> int[] toIntArray(Collection<T> coll) {
        if (coll == null) {
            return new int[0];
        }
        int[] values = new int[coll.size()];
        int index = 0;
        for (Number val : coll) {
            values[index++] = val.intValue();
        }
        return values;
    }

    public static <T> T[] toArray(Collection<T> coll, Class<T> type) {
        assert (type != null);
        if (coll == null) {
            return (Object[])Array.newInstance(type, 0);
        }
        Object[] array = (Object[])Array.newInstance(type, coll.size());
        return coll.toArray(array);
    }

    public static interface DoubleComparator {
        public int compare(double var1, double var3);
    }
}

