/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class SetMetrics {
    private final Hashtable<Class, Set<Object>> d_hash = new Hashtable();

    public SetMetrics(Collection s) {
        for (Object o : s) {
            this.add(o);
        }
    }

    public SetMetrics() {
        this(Collections.EMPTY_SET);
    }

    public void add(Object obj) {
        this.addEntry(obj.getClass(), obj);
    }

    public boolean contains(Object obj) {
        Set<Object> vals = this.d_hash.get(obj.getClass());
        if (vals != null) {
            return vals.contains(obj);
        }
        return false;
    }

    public void remove(Object obj) {
        this.removeEntry(obj.getClass(), obj);
    }

    public void clear() {
        this.d_hash.clear();
    }

    private void removeEntry(Class clazz, Object obj) {
        Set<Object> vals = this.d_hash.get(clazz);
        if (vals == null) {
            return;
        }
        vals.remove(obj);
    }

    private void addEntry(Class clazz, Object obj) {
        Set<Object> objs = this.d_hash.get(clazz);
        if (objs == null) {
            objs = new HashSet<Object>();
            this.d_hash.put(clazz, objs);
        }
        objs.add(obj);
    }

    public <T> Set<T> filter(Class<? extends T> ... clazzes) {
        HashSet<T> found = new HashSet<T>();
        for (Map.Entry<Class, Set<Object>> entry : this.d_hash.entrySet()) {
            for (Class<T> clazz : clazzes) {
                if (!clazz.isAssignableFrom(entry.getKey())) continue;
                for (Object o : entry.getValue()) {
                    found.add(clazz.cast(o));
                }
            }
        }
        return found;
    }

    public int getNum(Class ... clazzes) {
        return this.filter(clazzes).size();
    }

    public boolean isExclusive(Class ... clazzes) {
        boolean isPresent = false;
        for (Class key : this.d_hash.keySet()) {
            boolean keyIsPresent = false;
            for (Class clazz : clazzes) {
                if (!clazz.isAssignableFrom(key)) continue;
                keyIsPresent = true;
                break;
            }
            if (!keyIsPresent) {
                return false;
            }
            isPresent = true;
        }
        return isPresent;
    }
}

