/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.util;

import java.util.Collection;
import java.util.Iterator;
import pyrosim.legacy_2006_2.thunderheadeng.util.IObjectFilter;

public class FilteredIterator<T>
implements Iterator<T> {
    private final Iterator<?> d_it;
    private IObjectFilter<T> d_filter;
    private boolean d_hasNext = true;
    private T d_next;

    public FilteredIterator(Collection<?> objs, IObjectFilter<T> filter) {
        this.d_it = objs.iterator();
        this.d_filter = filter;
        this.prefetchNext();
    }

    private void prefetchNext() {
        if (!this.d_it.hasNext()) {
            this.d_hasNext = false;
            this.d_next = null;
            return;
        }
        while (this.d_it.hasNext()) {
            Object o = this.d_it.next();
            if (!this.d_filter.getType().isInstance(o) || this.d_filter.shouldFilter(o)) continue;
            this.d_next = this.d_filter.getType().cast(o);
            return;
        }
        this.d_hasNext = false;
        this.d_next = null;
    }

    @Override
    public boolean hasNext() {
        return this.d_hasNext;
    }

    @Override
    public T next() {
        T next = this.d_next;
        this.prefetchNext();
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

