/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.util;

import pyrosim.legacy_2006_2.thunderheadeng.util.ValueRange;

public abstract class AbstractValueRange<T extends Comparable>
implements ValueRange<T> {
    private T d_min;
    private T d_max;
    private boolean d_minInclusive;
    private boolean d_maxInclusive;
    private boolean d_checkMin = false;
    private boolean d_checkMax = false;

    public abstract String getDataType();

    public abstract String format(Object var1);

    protected AbstractValueRange(T min, T max, boolean checkMin, boolean checkMax, boolean minInclusive, boolean maxInclusive) {
        this.d_min = min;
        this.d_max = max;
        this.d_minInclusive = minInclusive;
        this.d_maxInclusive = maxInclusive;
        this.d_checkMin = checkMin;
        this.d_checkMax = checkMax;
    }

    @Override
    public boolean isMinInclusive() {
        return this.d_minInclusive;
    }

    @Override
    public boolean isMaxInclusive() {
        return this.d_maxInclusive;
    }

    @Override
    public T getMinValue() {
        return this.d_min;
    }

    @Override
    public void setMinValue(T min) {
        this.d_min = min;
    }

    @Override
    public T getMaxValue() {
        return this.d_max;
    }

    @Override
    public void setMaxValue(T max) {
        this.d_max = max;
    }

    @Override
    public boolean checksMin() {
        return this.d_checkMin;
    }

    @Override
    public boolean checksMax() {
        return this.d_checkMax;
    }

    @Override
    public boolean checkValue(T valueObj) {
        boolean minOk = true;
        boolean maxOk = true;
        if (this.d_checkMin) {
            if (this.d_minInclusive) {
                minOk = valueObj.compareTo(this.d_min) >= 0;
            } else {
                boolean bl = minOk = valueObj.compareTo(this.d_min) > 0;
            }
        }
        if (this.d_checkMax) {
            maxOk = this.d_maxInclusive ? valueObj.compareTo(this.d_max) <= 0 : valueObj.compareTo(this.d_max) < 0;
        }
        return minOk && maxOk;
    }

    protected T clampMinIncl(T val) {
        return this.d_min;
    }

    protected T clampMinUnincl(T val) {
        return null;
    }

    protected T clampMaxIncl(T val) {
        return this.d_max;
    }

    protected T clampMaxUnincl(T val) {
        return null;
    }

    @Override
    public T clampValue(T value) {
        if (this.d_checkMin) {
            if (this.d_minInclusive) {
                if (value.compareTo(this.d_min) < 0) {
                    return this.clampMinIncl(value);
                }
            } else {
                return this.clampMinUnincl(value);
            }
        }
        if (this.d_checkMax) {
            if (this.d_maxInclusive) {
                if (value.compareTo(this.d_max) > 0) {
                    return this.clampMaxIncl(value);
                }
            } else {
                return this.clampMaxUnincl(value);
            }
        }
        return value;
    }

    @Override
    public String describeRange() {
        String dataType = this.getDataType();
        char firstChar = dataType.charAt(0);
        String beginning = "";
        beginning = firstChar == 'a' || firstChar == 'e' || firstChar == 'i' || firstChar == 'o' || firstChar == 'u' ? "an" : "a";
        String desc = beginning + " " + dataType;
        if (this.d_checkMin) {
            desc = desc + (this.d_minInclusive ? " >= " : " > ") + this.format(this.d_min);
        }
        if (this.d_checkMin && this.d_checkMax) {
            desc = desc + " and";
        }
        if (this.d_checkMax) {
            desc = desc + (this.d_maxInclusive ? " <= " : " < ") + this.format(this.d_max);
        }
        return desc;
    }
}

