/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.scene3d.nativebuffered;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class BoundingBox3D {
    private Point3d d_min = new Point3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
    private Point3d d_max = new Point3d(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);

    public BoundingBox3D() {
    }

    public BoundingBox3D(Point3d min, Point3d max) {
        this.set(min, max);
    }

    public BoundingBox3D(double[] vals) {
        this.set(new Point3d(vals[0], vals[1], vals[2]), new Point3d(vals[3], vals[4], vals[5]));
    }

    public void set(Point3d min, Point3d max) {
        this.d_min.set(min);
        this.d_max.set(max);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("BoundingBox3D{");
        sb.append(this.getMin().toString() + " --> ");
        sb.append(this.getMax().toString() + "}");
        return sb.toString();
    }

    public Point3d getMin() {
        return this.d_min;
    }

    public Point3d getMax() {
        return this.d_max;
    }

    public void add(Point3d p) {
        if (p.x < this.d_min.x) {
            this.d_min.x = p.x;
        }
        if (p.x > this.d_max.x) {
            this.d_max.x = p.x;
        }
        if (p.y < this.d_min.y) {
            this.d_min.y = p.y;
        }
        if (p.y > this.d_max.y) {
            this.d_max.y = p.y;
        }
        if (p.z < this.d_min.z) {
            this.d_min.z = p.z;
        }
        if (p.z > this.d_max.z) {
            this.d_max.z = p.z;
        }
    }

    public void addForMin(Point3d p) {
        if (p.x < this.d_min.x) {
            this.d_min.x = p.x;
        }
        if (p.y < this.d_min.y) {
            this.d_min.y = p.y;
        }
        if (p.z < this.d_min.z) {
            this.d_min.z = p.z;
        }
    }

    public void addForMax(Point3d p) {
        if (p.x > this.d_max.x) {
            this.d_max.x = p.x;
        }
        if (p.y > this.d_max.y) {
            this.d_max.y = p.y;
        }
        if (p.z > this.d_max.z) {
            this.d_max.z = p.z;
        }
    }

    public BoundingBox3D ensureValidSize(double maxVal) {
        Point3d min = this.getMin();
        Point3d max = this.getMax();
        if (min.x == Double.MAX_VALUE) {
            min.x = -maxVal;
        }
        if (max.x == -1.7976931348623157E308) {
            max.x = maxVal;
        }
        if (min.y == Double.MAX_VALUE) {
            min.y = -maxVal;
        }
        if (max.y == -1.7976931348623157E308) {
            max.y = maxVal;
        }
        if (min.z == Double.MAX_VALUE) {
            min.z = -maxVal;
        }
        if (max.z == -1.7976931348623157E308) {
            max.z = maxVal;
        }
        Vector3d diff = new Vector3d();
        diff.sub(max, min);
        if (diff.x == 0.0 && diff.y == 0.0 && diff.z == 0.0) {
            min.add(new Point3d(maxVal, maxVal, maxVal));
            max.sub(new Point3d(maxVal, maxVal, maxVal));
        }
        this.set(min, max);
        return this;
    }
}

