/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.scene3d;

import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class Camera
implements Cloneable {
    public static final int LOCALAXIS_FORWARD = 0;
    public static final int LOCALAXIS_RIGHT = 1;
    public static final int LOCALAXIS_UP = 2;
    private Point3d d_pos;
    private Point3d d_ref;
    private Vector3d d_up;
    private double d_near;
    private double d_far;
    private double d_fov;
    private boolean d_orthographic;
    private double d_orthoScale;
    private Vector3d d_resetViewVector;
    private Vector3d d_resetUpVector;
    private Point3d d_resetPos;
    private Point3d d_resetRef;
    private boolean d_wireframe;
    private boolean d_flatShading;
    private boolean d_dirty;

    public Camera() {
        this.d_ref = new Point3d(0.0, 0.0, 0.0);
        this.d_pos = new Point3d(0.0, 0.0, 10.0);
        this.d_up = new Vector3d(0.0, 1.0, 0.0);
        this.d_resetPos = new Point3d(this.d_pos);
        this.d_resetRef = new Point3d(this.d_ref);
        this.d_resetUpVector = new Vector3d(this.d_up);
        this.d_fov = 65.0;
        this.d_near = 0.1;
        this.d_far = 100.0;
        this.d_resetViewVector = new Vector3d(0.0, 0.0, -1.0);
        this.d_orthographic = false;
        this.d_orthoScale = 1.0;
        this.d_wireframe = false;
        this.d_flatShading = false;
        this.d_dirty = true;
    }

    public Camera(Vector3d forward, Vector3d up, boolean wireframe, boolean flatShading) {
        this.d_pos = new Point3d(0.0, 0.0, 0.0);
        this.d_ref = new Point3d(0.0, 0.0, 0.0);
        this.d_ref.add(forward);
        this.d_up = new Vector3d(up);
        this.d_resetPos = new Point3d(this.d_pos);
        this.d_resetRef = new Point3d(this.d_ref);
        this.d_resetUpVector = new Vector3d(this.d_up);
        this.d_resetViewVector = new Vector3d(forward);
        this.d_fov = 65.0;
        this.d_near = 0.1;
        this.d_far = 100.0;
        this.d_orthographic = true;
        this.d_orthoScale = 10.0;
        this.d_wireframe = wireframe;
        this.d_flatShading = flatShading;
        this.d_dirty = true;
    }

    public Camera(Point3d eye, Point3d ref, Vector3d up, boolean wireframe, boolean flatShading) {
        this.d_ref = new Point3d(ref);
        this.d_pos = new Point3d(eye);
        this.d_up = new Vector3d(up);
        this.d_resetPos = new Point3d(eye);
        this.d_resetRef = new Point3d(ref);
        this.d_resetUpVector = new Vector3d(up);
        this.d_resetViewVector = new Vector3d();
        this.d_resetViewVector.sub(eye, ref);
        this.d_fov = 65.0;
        this.d_near = 0.1;
        this.d_far = 100.0;
        this.d_orthographic = false;
        this.d_orthoScale = 0.0;
        this.d_wireframe = wireframe;
        this.d_flatShading = flatShading;
        this.d_dirty = true;
    }

    public void resetRotation() {
        Vector3d pos = new Vector3d(this.d_pos);
        this.d_up.set(0.0, 0.0, 1.0);
        this.d_ref.set(0.0, 1.0, 0.0);
        this.d_pos.set(0.0, 0.0, 0.0);
        this.d_ref.add(pos);
        this.d_pos.add(pos);
        this.d_dirty = true;
    }

    public boolean isOrthographic() {
        return this.d_orthographic;
    }

    public void setOrthographic(boolean orthographic) {
        if (this.d_orthographic != orthographic) {
            this.d_orthographic = orthographic;
            this.d_dirty = true;
        }
    }

    public boolean isWireframe() {
        return this.d_wireframe;
    }

    public void setWireframe(boolean wireframe) {
        if (this.d_wireframe != wireframe) {
            this.d_wireframe = wireframe;
            this.d_dirty = true;
        }
    }

    public boolean isShadingFlat() {
        return this.d_flatShading;
    }

    public void setShadingFlat(boolean flat) {
        if (this.d_flatShading != flat) {
            this.d_flatShading = flat;
            this.d_dirty = true;
        }
    }

    public double getOrthoScale() {
        return this.d_orthoScale;
    }

    public void setOrthoScale(double scale) {
        if (this.d_orthoScale != scale) {
            this.d_orthoScale = scale;
            this.d_dirty = true;
        }
    }

    public Vector3d getResetViewVector() {
        return this.d_resetViewVector;
    }

    public void setResetViewVector(Vector3d view) {
        if (!view.equals(this.d_resetViewVector)) {
            this.d_resetViewVector.set(view);
            this.d_dirty = true;
        }
    }

    public Vector3d getResetUpVector() {
        return this.d_resetUpVector;
    }

    public void setResetUpVector(Vector3d view) {
        if (!view.equals(this.d_resetUpVector)) {
            this.d_resetUpVector.set(view);
            this.d_dirty = true;
        }
    }

    public void orbit(double deg, Vector3d axis) {
        Vector3d localX = new Vector3d();
        Vector3d localY = new Vector3d();
        Vector3d localZ = new Vector3d();
        localZ.sub(this.d_pos, this.d_ref);
        localY.set(this.d_up);
        localX.cross(localY, localZ);
        localX.normalize();
        localY.normalize();
        localZ.normalize();
        localX.scale(axis.x);
        localY.scale(axis.y);
        localZ.scale(axis.z);
        Vector3d newAxis = new Vector3d(0.0, 0.0, 0.0);
        newAxis.add(localX);
        newAxis.add(localY);
        newAxis.add(localZ);
        double angle = deg * Math.PI / 180.0;
        AxisAngle4d axisAngle = new AxisAngle4d(newAxis.x, newAxis.y, newAxis.z, angle);
        Matrix3d rot = new Matrix3d();
        rot.set(axisAngle);
        Vector3d pos = new Vector3d();
        pos.sub(this.d_pos, this.d_ref);
        rot.transform(pos);
        this.d_pos.add(this.d_ref, pos);
        rot.transform(this.d_up);
        this.d_dirty = true;
    }

    public void orbit(double deg, double vx, double vy, double vz) {
        Vector3d axis = new Vector3d(vx, vy, vz);
        this.orbit(deg, axis);
    }

    public void rotate(double deg, double vx, double vy, double vz) {
        double angle = deg * Math.PI / 180.0;
        AxisAngle4d axisAngle = new AxisAngle4d(vx, vy, vz, angle);
        Matrix3d rot = new Matrix3d();
        rot.set(axisAngle);
        Vector3d view = new Vector3d();
        view.sub(this.d_ref, this.d_pos);
        rot.transform(view);
        this.d_ref.add(this.d_pos, view);
        rot.transform(this.d_up);
        this.d_dirty = true;
    }

    public void zoom(double factor) {
        if (this.d_orthographic) {
            this.d_orthoScale /= factor;
        } else {
            this.d_fov /= factor;
        }
        this.d_dirty = true;
    }

    public void translateWorld(Vector3d offset, boolean offsetRef) {
        this.d_pos.add(offset);
        if (offsetRef) {
            this.d_ref.add(offset);
        }
        this.d_dirty = true;
    }

    public void translateEye(Vector3d offset, boolean offsetRef) {
        Vector3d localX = new Vector3d();
        Vector3d localY = new Vector3d();
        Vector3d localZ = new Vector3d();
        localZ.sub(this.d_pos, this.d_ref);
        localY.set(this.d_up);
        localX.cross(localY, localZ);
        localX.normalize();
        localY.normalize();
        localZ.normalize();
        localX.scale(offset.x);
        localY.scale(offset.y);
        localZ.scale(offset.z);
        Vector3d newOffset = new Vector3d(0.0, 0.0, 0.0);
        newOffset.add(localX);
        newOffset.add(localY);
        newOffset.add(localZ);
        this.d_pos.add(newOffset);
        if (offsetRef) {
            this.d_ref.add(newOffset);
        }
        this.d_dirty = true;
    }

    public void translateEye(double x, double y, double z, boolean offsetRef) {
        Vector3d tmp = new Vector3d(x, y, z);
        this.translateEye(tmp, offsetRef);
    }

    public void setPosition(Point3d pos) {
        if (!pos.equals(this.d_pos) || !pos.equals(this.d_resetPos)) {
            this.d_pos.set(pos);
            this.d_resetPos.set(pos);
            this.d_dirty = true;
        }
    }

    public void setPosition(double x, double y, double z) {
        Point3d pt = new Point3d(x, y, z);
        this.setPosition(pt);
    }

    public void setReference(Point3d ref) {
        if (!ref.equals(this.d_ref) || !ref.equals(this.d_resetRef)) {
            this.d_ref.set(ref);
            this.d_resetRef.set(ref);
            this.d_dirty = true;
        }
    }

    public void setReference(double x, double y, double z) {
        Point3d pt = new Point3d(x, y, z);
        this.setReference(pt);
    }

    public void setUpVector(Vector3d up) {
        if (!up.equals(this.d_up) || !up.equals(this.d_resetUpVector)) {
            this.d_up.set(up);
            this.d_resetUpVector.set(up);
            this.d_dirty = true;
        }
    }

    public void setUpVector(double x, double y, double z) {
        Vector3d v = new Vector3d(x, y, z);
        this.setUpVector(v);
    }

    public void setNearClip(double near) {
        if (near != this.d_near) {
            this.d_near = near;
            this.d_dirty = true;
        }
    }

    public void setFarClip(double far) {
        if (far != this.d_far) {
            this.d_far = far;
            this.d_dirty = true;
        }
    }

    public void setFieldOfView(double fov) {
        if (fov != this.d_fov) {
            this.d_fov = fov;
            this.d_dirty = true;
        }
    }

    public Point3d getPosition() {
        return new Point3d(this.d_pos);
    }

    public void getPosition(double[] v) {
        v[0] = this.d_pos.x;
        v[1] = this.d_pos.y;
        v[2] = this.d_pos.z;
    }

    public Point3d getReference() {
        return new Point3d(this.d_ref);
    }

    public void getReference(double[] v) {
        v[0] = this.d_ref.x;
        v[1] = this.d_ref.y;
        v[2] = this.d_ref.z;
    }

    public Vector3d getViewVector() {
        Vector3d view = new Vector3d(this.d_ref);
        view.sub(this.d_pos);
        return view;
    }

    public Vector3d getUpVector() {
        return new Vector3d(this.d_up);
    }

    public void getUpVector(double[] v) {
        v[0] = this.d_up.x;
        v[1] = this.d_up.y;
        v[2] = this.d_up.z;
    }

    public Vector3d getRightVector() {
        Vector3d up = this.getUpVector();
        Vector3d forward = this.getViewVector();
        Vector3d right = new Vector3d();
        right.cross(forward, up);
        return right;
    }

    public Vector3d getForwardVector() {
        if (this.d_orthographic) {
            return this.d_resetViewVector;
        }
        Vector3d forward = new Vector3d();
        forward.sub(this.d_ref, this.d_pos);
        return forward;
    }

    public double getNearClip() {
        return this.d_near;
    }

    public double getFarClip() {
        return this.d_far;
    }

    public double getFieldOfView() {
        return this.d_fov;
    }

    public double getDistance() {
        Vector3d tmp = new Vector3d();
        tmp.sub(this.d_ref, this.d_pos);
        return tmp.length();
    }

    public double getSubjectSize() {
        if (this.d_orthographic) {
            return this.getOrthoScale() * 2.0;
        }
        return this.d_fov * Math.PI / 180.0 * this.getDistance();
    }

    public Vector4d getViewPlane() {
        Vector3d view = this.getViewVector();
        view.normalize();
        Point3d position = this.getPosition();
        double d = -position.x * view.x - position.y * view.y - position.z * view.z;
        return new Vector4d(view.x, view.y, view.z, d);
    }

    public Vector3d vecToPointAlongLocalAxis(Point3d point, int localAxis) {
        Vector3d axis = new Vector3d();
        if (localAxis == 0) {
            axis.normalize(this.getViewVector());
        } else if (localAxis == 2) {
            axis.normalize(this.getUpVector());
        } else {
            Vector3d up = this.getUpVector();
            Vector3d forward = this.getViewVector();
            Vector3d right = new Vector3d();
            right.cross(forward, up);
            axis.normalize(right);
        }
        Vector3d pointToCam = new Vector3d();
        pointToCam.sub(point, this.getPosition());
        double length = pointToCam.dot(axis);
        axis.scale(length);
        return axis;
    }

    public Matrix3d getLocalTransformLHR() {
        Vector3d up = this.getUpVector();
        up.normalize();
        Vector3d right = this.getRightVector();
        right.normalize();
        Vector3d forward = this.getViewVector();
        forward.normalize();
        return new Matrix3d(right.x, right.y, right.z, up.x, up.y, up.z, forward.x, forward.y, forward.z);
    }

    public Matrix3d getLocalTransformRHR() {
        Matrix3d mat = this.getLocalTransformLHR();
        mat.m20 = -mat.m20;
        mat.m21 = -mat.m21;
        mat.m22 = -mat.m22;
        return mat;
    }

    public boolean isDirty() {
        return this.d_dirty;
    }

    public void setDirty(boolean dirty) {
        this.d_dirty = dirty;
    }

    public Object clone() {
        try {
            Camera clone = (Camera)super.clone();
            clone.d_pos = new Point3d(this.d_pos);
            clone.d_ref = new Point3d(this.d_ref);
            clone.d_up = new Vector3d(this.d_up);
            clone.d_resetViewVector = new Vector3d(this.d_resetViewVector);
            clone.d_resetUpVector = new Vector3d(this.d_resetUpVector);
            clone.d_resetPos = new Point3d(this.d_resetPos);
            clone.d_resetRef = new Point3d(this.d_resetRef);
            clone.d_orthographic = this.d_orthographic;
            clone.d_dirty = true;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return new Camera();
        }
    }
}

