/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.rasterization;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.vecmath.Point3i;
import pyrosim.legacy_2006_2.thunderheadeng.rasterization.IFragGenerator;
import pyrosim.legacy_2006_2.thunderheadeng.rasterization.IRasterization;

public class Raster3DMerger {
    public static <T> Map<MergedCell, IRasterization<? extends T>> mergeCells(Collection<? extends IRasterization<? extends T>> rasts) {
        HashMap<MergedCell, IRasterization<T>> p3iRastMap = new HashMap<MergedCell, IRasterization<T>>();
        for (IRasterization<T> rast : rasts) {
            for (Point3i cellIx : rast.getCells()) {
                p3iRastMap.put(new MergedCell(cellIx.x, cellIx.x, cellIx.y, cellIx.y, cellIx.z, cellIx.z), rast);
            }
        }
        Map<MergedCell, IRasterization<? extends T>> zMergedCells = Raster3DMerger.mergeCells(p3iRastMap, new PointComp(), new ZRunComp(), new ZRunMerger());
        p3iRastMap = null;
        Map<MergedCell, IRasterization<? extends T>> xzMergedCells = Raster3DMerger.mergeCells(zMergedCells, null, new XZRunComp(), new XZRunMerger());
        zMergedCells = null;
        Map<MergedCell, IRasterization<? extends T>> xyzMergedCells = Raster3DMerger.mergeCells(xzMergedCells, null, null, new XYZRunMerger());
        xzMergedCells = null;
        return xyzMergedCells;
    }

    private static <T> Map<MergedCell, IRasterization<? extends T>> mergeCells(Map<MergedCell, IRasterization<? extends T>> preMerges, Comparator<MergedCell> optPreSorter, Comparator<MergedCell> optPostSorter, Merger merger) {
        Map<MergedCell, IRasterization<T>> preSorted;
        if (optPreSorter != null) {
            preSorted = new TreeMap<MergedCell, IRasterization<? extends T>>(optPreSorter);
            for (Map.Entry<MergedCell, IRasterization<T>> entry : preMerges.entrySet()) {
                preSorted.put(entry.getKey(), entry.getValue());
            }
        } else {
            preSorted = preMerges;
        }
        Map.Entry[] entries = (Map.Entry[])Array.newInstance(Map.Entry.class, preSorted.size());
        preSorted.entrySet().toArray(entries);
        TreeMap<MergedCell, IRasterization<T>> result = optPostSorter != null ? new TreeMap(optPostSorter) : new HashMap();
        int m = 0;
        while (m < entries.length) {
            int n;
            MergedCell prm1 = (MergedCell)entries[m].getKey();
            IFragGenerator fragGen1 = ((IRasterization)entries[m].getValue()).getFragGenerator();
            MergedCell merged = merger.init(prm1);
            for (n = m + 1; n < entries.length; ++n) {
                MergedCell prm2 = (MergedCell)entries[n].getKey();
                IFragGenerator fragGen2 = ((IRasterization)entries[n].getValue()).getFragGenerator();
                if (!merger.areCellsAdjacent(merged, prm2) || !fragGen1.canMerge(fragGen2)) break;
                merged = merger.merge(merged, prm2);
            }
            result.put(merged, (IRasterization)entries[m].getValue());
            m = n;
        }
        return result;
    }

    public static class MergedCell {
        public int x1;
        public int x2;
        public int y1;
        public int y2;
        public int z1;
        public int z2;

        public MergedCell(int x1, int x2, int y1, int y2, int z1, int z2) {
            this.x1 = x1;
            this.x2 = x2;
            this.y1 = y1;
            this.y2 = y2;
            this.z1 = z1;
            this.z2 = z2;
        }
    }

    private static class PointComp
    implements Comparator<MergedCell> {
        private PointComp() {
        }

        @Override
        public int compare(MergedCell p1, MergedCell p2) {
            int ydiff = p1.y1 - p2.y1;
            if (ydiff != 0) {
                return ydiff;
            }
            int xdiff = p1.x1 - p2.x1;
            if (xdiff != 0) {
                return xdiff;
            }
            return p1.z1 - p2.z1;
        }
    }

    private static class ZRunComp
    implements Comparator<MergedCell> {
        private ZRunComp() {
        }

        @Override
        public int compare(MergedCell r1, MergedCell r2) {
            int ydiff = r1.y1 - r2.y1;
            if (ydiff != 0) {
                return ydiff;
            }
            int z1diff = r1.z1 - r2.z1;
            if (z1diff != 0) {
                return z1diff;
            }
            int rzlen1 = r1.z2 - r1.z1 + 1;
            int rzlen2 = r2.z2 - r2.z1 + 1;
            int rzdiff = rzlen1 - rzlen2;
            if (rzdiff != 0) {
                return rzdiff;
            }
            return r1.x1 - r2.x1;
        }
    }

    private static class ZRunMerger
    implements Merger {
        private ZRunMerger() {
        }

        @Override
        public boolean areCellsAdjacent(MergedCell cell1, MergedCell cell2) {
            return cell1.x1 == cell2.x1 && cell1.y1 == cell2.y1 && cell1.z2 == cell2.z1 - 1;
        }

        @Override
        public MergedCell init(MergedCell cell) {
            return new MergedCell(cell.x1, cell.x1, cell.y1, cell.y1, cell.z1, cell.z1);
        }

        @Override
        public MergedCell merge(MergedCell cell1, MergedCell cell2) {
            cell1.z2 = cell2.z1;
            return cell1;
        }
    }

    private static interface Merger {
        public MergedCell init(MergedCell var1);

        public boolean areCellsAdjacent(MergedCell var1, MergedCell var2);

        public MergedCell merge(MergedCell var1, MergedCell var2);
    }

    private static class XZRunComp
    implements Comparator<MergedCell> {
        private XZRunComp() {
        }

        @Override
        public int compare(MergedCell r1, MergedCell r2) {
            int x1diff = r1.x1 - r2.x1;
            if (x1diff != 0) {
                return x1diff;
            }
            int rxlen1 = r1.x2 - r1.x1 + 1;
            int rxlen2 = r2.x2 - r2.x1 + 1;
            int rxdiff = rxlen1 - rxlen2;
            if (rxdiff != 0) {
                return rxdiff;
            }
            int z1diff = r1.z1 - r2.z1;
            if (z1diff != 0) {
                return z1diff;
            }
            int rzlen1 = r1.z2 - r1.z1 + 1;
            int rzlen2 = r2.z2 - r2.z1 + 1;
            int rzdiff = rzlen1 - rzlen2;
            if (rzdiff != 0) {
                return rzdiff;
            }
            return r1.y1 - r2.y1;
        }
    }

    private static class XZRunMerger
    implements Merger {
        private XZRunMerger() {
        }

        @Override
        public boolean areCellsAdjacent(MergedCell cell1, MergedCell cell2) {
            return cell1.y1 == cell2.y1 && cell1.z1 == cell2.z1 && cell1.z2 == cell2.z2 && cell1.x2 == cell2.x1 - 1;
        }

        @Override
        public MergedCell init(MergedCell cell) {
            return new MergedCell(cell.x1, cell.x1, cell.y1, cell.y1, cell.z1, cell.z2);
        }

        @Override
        public MergedCell merge(MergedCell cell1, MergedCell cell2) {
            cell1.x2 = cell2.x1;
            return cell1;
        }
    }

    private static class XYZRunMerger
    implements Merger {
        private XYZRunMerger() {
        }

        @Override
        public boolean areCellsAdjacent(MergedCell cell1, MergedCell cell2) {
            return cell1.x1 == cell2.x1 && cell1.x2 == cell2.x2 && cell1.z1 == cell2.z1 && cell1.z2 == cell2.z2 && cell1.y2 == cell2.y1 - 1;
        }

        @Override
        public MergedCell init(MergedCell cell) {
            return new MergedCell(cell.x1, cell.x2, cell.y1, cell.y1, cell.z1, cell.z2);
        }

        @Override
        public MergedCell merge(MergedCell cell1, MergedCell cell2) {
            cell1.y2 = cell2.y1;
            return cell1;
        }
    }
}

