/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.io;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;

public class ObjectSelection
implements Transferable,
ClipboardOwner {
    private DataFlavor d_serializedFlavor;
    private Serializable d_object;
    private String d_string;

    public ObjectSelection(Serializable object, String str, DataFlavor flavor) {
        this.d_object = object;
        this.d_string = str;
        this.d_serializedFlavor = flavor;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        LinkedList<DataFlavor> flavors = new LinkedList<DataFlavor>();
        if (this.d_string != null) {
            flavors.add(DataFlavor.stringFlavor);
        }
        if (this.d_object != null) {
            flavors.add(this.d_serializedFlavor);
        }
        return flavors.toArray(new DataFlavor[flavors.size()]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.d_object != null && flavor.match(this.d_serializedFlavor) || this.d_string != null && flavor.match(DataFlavor.stringFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.match(DataFlavor.stringFlavor) && this.d_string != null) {
            return this.d_string;
        }
        if (flavor.match(this.d_serializedFlavor) && this.d_object != null) {
            return this.d_object;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

