/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.thunderheadeng.geometry;

import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class Util {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int Z_AXIS = 2;
    public static final Tuple3d TUP3D_ZERO = new Point3d(0.0, 0.0, 0.0);
    public static final Vector3d VEC3D_XPOS = new Vector3d(1.0, 0.0, 0.0);
    public static final Vector3d VEC3D_XNEG = new Vector3d(-1.0, 0.0, 0.0);
    public static final Vector3d VEC3D_YPOS = new Vector3d(0.0, 1.0, 0.0);
    public static final Vector3d VEC3D_YNEG = new Vector3d(0.0, -1.0, 0.0);
    public static final Vector3d VEC3D_ZPOS = new Vector3d(0.0, 0.0, 1.0);
    public static final Vector3d VEC3D_ZNEG = new Vector3d(0.0, 0.0, -1.0);
    public static final Point3d PNT3D_XPOS = new Point3d(1.0, 0.0, 0.0);
    public static final Point3d PNT3D_XNEG = new Point3d(-1.0, 0.0, 0.0);
    public static final Point3d PNT3D_YPOS = new Point3d(0.0, 1.0, 0.0);
    public static final Point3d PNT3D_YNEG = new Point3d(0.0, -1.0, 0.0);
    public static final Point3d PNT3D_ZPOS = new Point3d(0.0, 0.0, 1.0);
    public static final Point3d PNT3D_ZNEG = new Point3d(0.0, 0.0, -1.0);

    public static Vector4d getPlane(Point3d ... points) {
        Point3d p0 = points[0];
        Vector3d v1 = new Vector3d();
        v1.sub(points[1], p0);
        Vector3d v2 = new Vector3d();
        v2.sub(points[2], p0);
        Vector3d normal = new Vector3d();
        normal.cross(v1, v2);
        normal.normalize();
        double d = -(normal.x * p0.x + normal.y * p0.y + normal.z * p0.z);
        return new Vector4d(normal.x, normal.y, normal.z, d);
    }

    public static Vector4d getPlane(Vector3d normal, Point3d pointOnPlane) {
        double d = -(normal.x * pointOnPlane.x + normal.y * pointOnPlane.y + normal.z * pointOnPlane.z);
        return new Vector4d(normal.x, normal.y, normal.z, d);
    }

    public static double distance(Point3d point, Vector4d plane) {
        return point.x * plane.x + point.y * plane.y + point.z * plane.z + plane.w;
    }

    public static int getClosestAxis(Vector3d vec) {
        double closestOneDiff;
        int closestAxis;
        Vector3d vecNorm = new Vector3d();
        vecNorm.normalize(vec);
        double xdot = vecNorm.dot(VEC3D_XPOS);
        double ydot = vecNorm.dot(VEC3D_YPOS);
        double zdot = vecNorm.dot(VEC3D_ZPOS);
        double xdotOneDiff = Math.abs(Math.abs(xdot) - 1.0);
        double ydotOneDiff = Math.abs(Math.abs(ydot) - 1.0);
        double zdotOneDiff = Math.abs(Math.abs(zdot) - 1.0);
        if (xdotOneDiff < ydotOneDiff) {
            closestAxis = 0;
            closestOneDiff = xdotOneDiff;
        } else {
            closestAxis = 1;
            closestOneDiff = ydotOneDiff;
        }
        if (zdotOneDiff < closestOneDiff) {
            closestAxis = 2;
        }
        return closestAxis;
    }
}

