/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.legacy.v17;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;

public class TextureInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String d_texname;
    private transient BufferedImage d_texdata;
    private double d_width;
    private double d_height;
    public static final int ORIGIN_DIRSCAN = 0;
    public static final int ORIGIN_DBREF = 1;
    public static final int ORIGIN_USER = 2;
    private int d_origin;

    public TextureInfo(String fn, BufferedImage data, int origin) {
        this(fn, data, 1.0, 1.0, origin);
    }

    public TextureInfo(String fn, BufferedImage data, double wid, double ht, int origin) {
        this.d_texname = fn;
        this.d_texdata = data;
        this.d_width = wid;
        this.d_height = ht;
        this.d_origin = origin;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.d_texname);
        out.writeDouble(this.d_width);
        out.writeDouble(this.d_height);
        out.writeInt(this.d_origin);
        ImageIO.write((RenderedImage)this.d_texdata, "jpg", out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.d_texname = (String)in.readObject();
        this.d_width = in.readDouble();
        this.d_height = in.readDouble();
        this.d_origin = in.readInt();
        this.d_texdata = ImageIO.read(in);
    }

    public String getFileName() {
        return this.d_texname;
    }

    public BufferedImage getImage() {
        return this.d_texdata;
    }

    public double getWidth() {
        return this.d_width;
    }

    public double getHeight() {
        return this.d_height;
    }

    public void setWidth(double wid) {
        this.d_width = wid;
    }

    public void setHeight(double ht) {
        this.d_height = ht;
    }

    public int getOrigin() {
        return this.d_origin;
    }

    public int hashCode() {
        return this.d_texname.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[[TextureInfo]");
        sb.append(this.d_texname + ":");
        sb.append(this.d_origin + ":");
        sb.append(this.d_width + ":");
        sb.append(this.d_height + "]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TextureInfo && obj != null) {
            TextureInfo ti = (TextureInfo)obj;
            return ti.d_texname.equals(this.d_texname) && ti.d_height == this.d_height && ti.d_width == this.d_width && ti.d_origin == this.d_origin;
        }
        return false;
    }
}

