/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.legacy.v17;

import java.awt.Color;
import java.io.Serializable;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2006_2.geom.Prism;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.Point3D;

public class Quad
implements Serializable {
    static final long serialVersionUID = 1L;
    private Point3D[] d_points;
    private Color d_color;

    public Quad(double[] coords) {
        if (coords.length != 12) {
            throw new IllegalArgumentException("This Quad construction requires 12 coordinates (p0.x, p0.y, p0.z, p1.x, ..., p3.z).");
        }
        this.init(new Point3D[]{new Point3D(coords[0], coords[1], coords[2]), new Point3D(coords[3], coords[4], coords[5]), new Point3D(coords[6], coords[7], coords[8]), new Point3D(coords[9], coords[10], coords[11])});
    }

    public Quad(Point3D p0, Point3D p1, Point3D p2, Point3D p3) {
        this.init(new Point3D[]{p0, p1, p2, p3});
    }

    public Quad(Point3D[] points) {
        this.init(points);
    }

    private void init(Point3D[] points) {
        if (points.length != 4) {
            throw new IllegalArgumentException("Quad must have 4 points.");
        }
        this.d_points = points;
    }

    public boolean equals(Object obj) {
        int ip;
        if (!(obj instanceof Quad)) {
            return false;
        }
        Quad q = (Quad)obj;
        Point3D p = this.getPoint(0);
        for (ip = 0; ip < 4 && !p.equals(q.getPoint(ip)); ++ip) {
        }
        if (ip >= 4) {
            return false;
        }
        int offset = ip;
        for (ip = 1; ip < 4; ++ip) {
            if (this.getPoint(ip).equals(q.getPoint((ip + offset) % 4))) continue;
            return false;
        }
        return true;
    }

    public Vector3d getNormal() {
        Point3D baseO = this.getPoint(0);
        Point3D p1O = this.getPoint(1);
        Point3D p2O = this.getPoint(2);
        Point3d base = new Point3d(baseO.x, baseO.y, baseO.z);
        Point3d p1 = new Point3d(p1O.x, p1O.y, p1O.z);
        Point3d p2 = new Point3d(p2O.x, p2O.y, p2O.z);
        Vector3d ref1 = new Vector3d();
        ref1.sub(p1, base);
        Vector3d ref2 = new Vector3d();
        ref2.sub(p2, base);
        Vector3d normal = new Vector3d();
        normal.cross(ref1, ref2);
        normal.normalize();
        return normal;
    }

    public boolean isParallelZ() {
        return this.getPoint((int)0).z == this.getPoint((int)1).z && this.getPoint((int)0).z == this.getPoint((int)2).z && this.getPoint((int)0).z == this.getPoint((int)3).z;
    }

    public boolean isParallelX() {
        return this.getPoint((int)0).x == this.getPoint((int)1).x && this.getPoint((int)0).x == this.getPoint((int)2).x && this.getPoint((int)0).x == this.getPoint((int)3).x;
    }

    public boolean isParallelY() {
        return this.getPoint((int)0).y == this.getPoint((int)1).y && this.getPoint((int)0).y == this.getPoint((int)2).y && this.getPoint((int)0).y == this.getPoint((int)3).y;
    }

    public Point3D getPoint(int index) {
        return this.d_points[index];
    }

    public void setPoint(Point3D point, int index) {
        this.d_points[index] = point;
    }

    public void translate(double dx, double dy, double dz) {
        for (int i = 0; i < this.d_points.length; ++i) {
            this.d_points[i].x += dx;
            this.d_points[i].y += dy;
            this.d_points[i].z += dz;
        }
    }

    public void flipNormal() {
        Point3D temp = this.d_points[1];
        this.d_points[1] = this.d_points[3];
        this.d_points[3] = temp;
    }

    public Color getColor() {
        return this.d_color;
    }

    public void setColor(Color color) {
        this.d_color = color;
    }

    public Prism extrudeAlongNormal(double amount) {
        double halfAmount = amount * 0.5;
        double minX = this.d_points[0].x;
        double maxX = this.d_points[2].x;
        double minY = this.d_points[0].y;
        double maxY = this.d_points[2].y;
        double minZ = this.d_points[0].z;
        double maxZ = this.d_points[2].z;
        if (this.isParallelX()) {
            minX -= halfAmount;
            maxX += halfAmount;
        } else if (this.isParallelY()) {
            minY -= halfAmount;
            maxY += halfAmount;
        } else if (this.isParallelZ()) {
            minZ -= halfAmount;
            maxZ += halfAmount;
        }
        return new Prism(minX, maxX, minY, maxY, minZ, maxZ);
    }

    public Object clone() {
        Point3D[] points = new Point3D[]{new Point3D(this.d_points[0].x, this.d_points[0].y, this.d_points[0].z), new Point3D(this.d_points[1].x, this.d_points[1].y, this.d_points[1].z), new Point3D(this.d_points[2].x, this.d_points[2].y, this.d_points[2].z), new Point3D(this.d_points[3].x, this.d_points[3].y, this.d_points[3].z)};
        Quad q = new Quad(points);
        q.setColor(this.d_color);
        return q;
    }
}

