/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.legacy.v16;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Set;
import pyrosim.legacy_2006_2.UnitPoint2D;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.IFace;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.dependencies.IDependedOn;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.legacy.v16.AlignedHole;
import pyrosim.legacy_2006_2.legacy.v16.Wall;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class Hole
extends Wall
implements Serializable {
    static final long serialVersionUID = 1L;
    private static final double ALPHA = 0.4;
    public static final Color DEF_COLOR = new Color(Color.GRAY.getRed(), Color.GRAY.getGreen(), Color.GRAY.getBlue(), 102);

    public Hole(UnitPoint2D a, UnitPoint2D b, UnitDouble bottom, UnitDouble top, UnitDouble thickness) {
        super(a, b, bottom, top, thickness, null);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Hole)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public void imprint(Object baseObject) {
        if (!(baseObject instanceof Hole)) {
            return;
        }
        ADomainObject.pauseUpdates(this, false);
        super.imprint(baseObject);
        Hole obj = (Hole)baseObject;
        this.setColor(obj.getColor());
        ADomainObject.resumeUpdates(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    protected void fillInputRecordExtras(FDSInputRecord rec) {
    }

    @Override
    protected FDSObject createAlignedSegment(UnitPoint3D min, UnitPoint3D max, Material mat, String name) {
        AlignedHole segment = new AlignedHole(min, max, name);
        segment.setColor(this.getColor());
        return segment;
    }

    @Override
    public void setColor(Color c) {
        if (c != null) {
            super.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 102));
        } else {
            super.setColor(null);
        }
    }

    @Override
    public String getFDSType() {
        return "HOLE";
    }

    @Override
    public void setMaterial(int faceIndex, Material mat) {
    }

    @Override
    public Material getMaterial(int faceIndex) {
        return null;
    }

    @Override
    protected IFace createFace(Wall wall, byte internalFaceIndex, Material mat) {
        return new BlockFace(wall, internalFaceIndex, mat);
    }

    @Override
    public String getTypeDescription() {
        return "Hole";
    }

    @Override
    public boolean dependsOnObject(IDependedOn depOn) {
        if (depOn instanceof Material) {
            return false;
        }
        return super.dependsOnObject(depOn);
    }

    @Override
    public void getObjectsDependedOn(Set<IDependedOn> dependencies, Class<IDependedOn> type) {
        if (Material.class.isAssignableFrom(type)) {
            return;
        }
        super.getObjectsDependedOn(dependencies, type);
    }

    @Override
    public Task taskUpdateAfterDependedOnChanged(IDependedOn dep, Object info) {
        if (dep instanceof Material) {
            return null;
        }
        return super.taskUpdateAfterDependedOnChanged(dep, info);
    }

    @Override
    public Task taskUpdateAfterDependedOnReplaced(IDependedOn old, IDependedOn replacement) {
        if (old instanceof Material) {
            return null;
        }
        return super.taskUpdateAfterDependedOnReplaced(old, replacement);
    }

    @Override
    public Task taskUpdateBeforeDependedOnRenamed(IDependedOn dep, String newID) {
        if (dep instanceof Material) {
            return null;
        }
        return super.taskUpdateBeforeDependedOnRenamed(dep, newID);
    }

    public static class BlockFace
    extends Wall.BlockFace
    implements Serializable {
        static final long serialVersionUID = 1L;

        public BlockFace(Wall block, byte index, Material material) {
            super(block, index, material);
        }

        @Override
        protected Color getDefaultColor() {
            return DEF_COLOR;
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        }
    }
}

