/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.legacy.v15;

import java.awt.Color;
import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.dependencies.IDependedOn;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.legacy.v16.AlignedBlock;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;

public class Hole
extends AlignedBlock
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private static final double ALPHA = 0.4;
    public static final Color DEF_COLOR = new Color(Color.GRAY.getRed(), Color.GRAY.getGreen(), Color.GRAY.getBlue(), 102);

    public Hole() {
        this((UnitPoint3D)null, (UnitPoint3D)null);
    }

    public Hole(UnitPoint3D minPoint, UnitPoint3D maxPoint) {
        this(minPoint, maxPoint, "Hole");
    }

    public Hole(UnitPoint3D minPoint, UnitPoint3D maxPoint, String description) {
        super(minPoint, maxPoint, description, null);
        this.setColor(null);
    }

    @Override
    public Object clone() {
        Hole clone = (Hole)super.clone();
        return clone;
    }

    @Override
    public void imprint(Object baseObject) {
        if (!(baseObject instanceof Hole)) {
            return;
        }
        ADomainObject.pauseUpdates(this, false);
        super.imprint(baseObject);
        Hole obj = (Hole)baseObject;
        this.setColor(obj.getColor());
        ADomainObject.resumeUpdates(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Hole)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public void setColor(Color c) {
        if (c != null) {
            super.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 102));
        } else {
            super.setColor(null);
        }
    }

    @Override
    public String toString() {
        Object str = "";
        String name = this.getName();
        if (name != null && !name.equals("")) {
            str = (String)str + " [" + name + "]";
        }
        return str;
    }

    @Override
    public String getFDSType() {
        return "HOLE";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> recs) {
        Collection eventRecords;
        FDSInputRecord rec = new FDSInputRecord();
        rec.setType("HOLE");
        UnitPoint3D minPoint = this.getMinPoint();
        UnitPoint3D maxPoint = this.getMaxPoint();
        Vector<Double> coords = new Vector<Double>(6);
        Unit u = FdsSISystem.getInstance().getLengthUnit();
        coords.add(minPoint.x(u));
        coords.add(maxPoint.x(u));
        coords.add(minPoint.y(u));
        coords.add(maxPoint.y(u));
        coords.add(minPoint.z(u));
        coords.add(maxPoint.z(u));
        rec.setValue("XB", coords);
        rec.setComment(this.getName());
        if (this.getColor() != null) {
            float[] rgb = this.getColor().getRGBComponents(null);
            Vector<Double> color = new Vector<Double>(3);
            color.add(Double.valueOf(rgb[0]));
            color.add(Double.valueOf(rgb[1]));
            color.add(Double.valueOf(rgb[2]));
            rec.setValue("RGB", color);
        }
        if ((eventRecords = this.getEventInputRecords(rec)).size() != 0) {
            recs.addAll(eventRecords);
        } else {
            recs.add(rec);
        }
    }

    @Override
    public void setMaterial(int faceIndex, Material mat) {
    }

    @Override
    public Material getMaterial(int faceIndex) {
        return null;
    }

    @Override
    public String getTypeDescription() {
        return "Hole";
    }

    @Override
    public boolean dependsOnObject(IDependedOn depOn) {
        if (depOn instanceof Material) {
            return false;
        }
        return super.dependsOnObject(depOn);
    }
}

