/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.legacy;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.Vector;
import pyrosim.legacy_2006_2.domain.Ramp;
import pyrosim.legacy_2006_2.domain.RampRecord;

public class RampList
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private Vector<RampRecord> d_rampList = new Vector();

    public Collection toCollection() {
        return this.d_rampList;
    }

    public RampRecord getRampRecord(int index) {
        return this.d_rampList.elementAt(index);
    }

    public Collection<RampRecord> getRampRecords(String name) {
        Vector<RampRecord> ramps = new Vector<RampRecord>();
        for (int i = 0; i < this.d_rampList.size(); ++i) {
            RampRecord r = this.d_rampList.get(i);
            if (!r.getName().equals(name)) continue;
            ramps.add(r);
        }
        return ramps;
    }

    public Ramp getRamp(String name) {
        Collection<RampRecord> ramps = this.getRampRecords(name);
        return new Ramp(name, ramps);
    }

    public Object clone() throws CloneNotSupportedException {
        RampList temp = new RampList();
        for (int i = 0; i < this.d_rampList.size(); ++i) {
            RampRecord tempRec = this.d_rampList.elementAt(i);
            temp.d_rampList.add((RampRecord)tempRec.clone());
        }
        return temp;
    }

    public int getCount() {
        return this.d_rampList.size();
    }

    public int getRampCount() {
        return this.getAllRamps().size();
    }

    public RampRecord[] getAllRampList() {
        return this.d_rampList.toArray(new RampRecord[this.d_rampList.size()]);
    }

    public Collection<Ramp> getAllRamps() {
        Cloneable r;
        LinkedList<Ramp> ramps = new LinkedList<Ramp>();
        TreeSet<String> names = new TreeSet<String>();
        for (int m = 0; m < this.d_rampList.size(); ++m) {
            r = this.d_rampList.get(m);
            names.add(r.getName());
        }
        Iterator nameIt = names.iterator();
        while (nameIt.hasNext()) {
            r = this.getRamp((String)nameIt.next());
            ramps.add((Ramp)r);
        }
        return ramps;
    }

    public void addRampRecord(RampRecord newRampRecord) {
        this.d_rampList.add(newRampRecord);
    }

    public void addRamp(Ramp newRamp) {
        Collection<RampRecord> rampRecords = newRamp.getRecords();
        this.d_rampList.addAll(rampRecords);
    }

    public void clearRampList() {
        this.d_rampList.removeAllElements();
    }

    public boolean containsRampNamed(String name) {
        for (int m = 0; m < this.d_rampList.size(); ++m) {
            RampRecord ramp = this.d_rampList.get(m);
            if (!ramp.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

