/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;

public class TimeProcessor
extends AFDSRecordProcessor {
    public TimeProcessor(FDSParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public String getFDSTypeParsed() {
        return "TIME";
    }

    @Override
    public boolean process(FDSInputRecord rec) throws FDSRecordFormatException {
        if (!"TIME".equals(rec.getType())) {
            return false;
        }
        boolean err = false;
        try {
            Unit timeUnit = FdsSISystem.getInstance().getTimeUnit();
            PyroMod.TimeRecord tr = this.getContainer().getTimeManager().getTimeRecord();
            UnitDouble twfin = rec.extractDouble("TWFIN", timeUnit, tr.getSimulationStopTime(), (UnitDoubleValueRange)PyroMod.TimeRecord.getValueRange("TWFIN"));
            tr.setSimulationStopTime(twfin);
            UnitDouble dt = rec.extractDouble("DT", timeUnit, tr.getInitialTimeStep(), (UnitDoubleValueRange)PyroMod.TimeRecord.getValueRange("DT"));
            tr.setInitialTimeStep(dt);
            this.flagPyroTypeAffected(PyroMod.TimeRecord.class);
        }
        catch (ClassCastException e) {
            err = true;
        }
        if (err) {
            throw new FDSRecordFormatException(rec);
        }
        return true;
    }

    @Override
    public void done() throws FDSRecordFormatException {
    }
}

