/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.SmodList;
import pyrosim.legacy_2006_2.domain.SmodRecord;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class SmodProcessor
extends AFDSRecordProcessor {
    public SmodProcessor(FDSParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public boolean process(FDSInputRecord rec) throws FDSRecordFormatException {
        Unit u;
        Unit lu;
        if (!rec.getType().equals("SMOD")) {
            return false;
        }
        SmodList smList = this.getContainer().getSmokeDetectors();
        SmodRecord smod = new SmodRecord(smList);
        String reqLabel = (String)rec.getValue("LABEL");
        Vector reqXYZ = (Vector)rec.getValue("XYZ");
        Double reqLen = (Double)rec.getValue("LENGTH");
        Double reqAlphaC = (Double)rec.getValue("ALPHA_C");
        Double reqBetaC = (Double)rec.getValue("BETA_C");
        Double reqAlphaE = (Double)rec.getValue("ALPHA_E");
        Double reqBetaE = (Double)rec.getValue("BETA_E");
        Double reqObs = (Double)rec.getValue("ACTIVATION_OBSCURATION");
        if (reqLabel != null && !smList.contains(reqLabel)) {
            smod.setLabel(reqLabel);
        }
        if (reqXYZ != null) {
            try {
                lu = FdsSISystem.getInstance().getLengthUnit();
                double x = (Double)reqXYZ.get(0);
                double y = (Double)reqXYZ.get(1);
                double z = (Double)reqXYZ.get(2);
                UnitPoint3D unitLocation = new UnitPoint3D(x, y, z, lu);
                smod.setLocation(unitLocation);
            }
            catch (Exception e) {
                throw new FDSRecordFormatException(rec);
            }
        }
        if (reqLen != null) {
            lu = FdsSISystem.getInstance().getLengthUnit();
            UnitDouble len = new UnitDouble(reqLen, lu);
            smod.setHLength(len);
        }
        if (reqAlphaC != null) {
            u = FdsSISystem.getInstance().getUnitlessUnit();
            UnitDouble alphaC = new UnitDouble(reqAlphaC, u);
            smod.setCAlphaC(alphaC);
        }
        if (reqBetaC != null) {
            u = FdsSISystem.getInstance().getUnitlessUnit();
            UnitDouble betaC = new UnitDouble(reqBetaC, u);
            smod.setCBetaC(betaC);
        }
        if (reqAlphaE != null) {
            u = FdsSISystem.getInstance().getUnitlessUnit();
            UnitDouble alphaE = new UnitDouble(reqAlphaE, u);
            smod.setCAlphaE(alphaE);
        }
        if (reqBetaE != null) {
            u = FdsSISystem.getInstance().getUnitlessUnit();
            UnitDouble betaE = new UnitDouble(reqBetaE, u);
            smod.setCBetaE(betaE);
        }
        if (reqObs != null) {
            u = FdsSISystem.getInstance().getObscurationUnit();
            UnitDouble obs = new UnitDouble(reqObs, u);
            smod.setObscuration(obs);
        }
        if (reqAlphaC != null && reqBetaC != null && reqAlphaE != null && reqBetaE != null) {
            smod.setType(1);
        } else {
            smod.setType(0);
        }
        smList.taskAdd(smod).run();
        this.flagPyroTypeAffected(SmodRecord.class);
        return true;
    }

    @Override
    public void done() throws FDSRecordFormatException {
    }

    @Override
    public String getFDSTypeParsed() {
        return "SMOD";
    }
}

