/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.domain.GasPhaseQuantitiesList;
import pyrosim.legacy_2006_2.domain.SlcfRecord;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;

public class SlcfProcessor
extends AFDSRecordProcessor {
    public SlcfProcessor(FDSParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public String getFDSTypeParsed() {
        return "SLCF";
    }

    @Override
    public boolean process(FDSInputRecord rec) throws FDSRecordFormatException {
        boolean err = false;
        FDSRecordFormatException caughtExc = null;
        try {
            if (rec.getType() == null) {
                throw new Exception();
            }
            if (!"SLCF".equals(rec.getType())) {
                return false;
            }
            if (this.containsUnsupportedRecords(rec)) {
                return false;
            }
            String xyzPlane = "";
            String[] allKeys = rec.getKeys();
            for (int n = 0; n < allKeys.length; ++n) {
                if (allKeys[n] == null || !allKeys[n].startsWith("PB")) continue;
                xyzPlane = allKeys[n];
                break;
            }
            if (xyzPlane.equals("")) {
                throw new FDSRecordFormatException(rec, "Currently, geometry must be specified with a PBX, PBY, or PBZ field in SLCF records.");
            }
            boolean useVector = false;
            FdsSISystem si = FdsSISystem.getInstance();
            UnitDouble dtsam = rec.extractDouble("DTSAM", si.getTimeUnit(), null, (UnitDoubleValueRange)SlcfRecord.getValueRange("DTSAM"));
            for (int i = 0; i < allKeys.length; ++i) {
                if (!allKeys[i].equals("VECTOR") || !((Boolean)rec.getValue("VECTOR")).booleanValue()) continue;
                useVector = true;
            }
            double xyzValue = (Double)rec.getValue(xyzPlane);
            String quantity = (String)rec.getValue("QUANTITY");
            Unit lengthU = FdsSISystem.getInstance().getLengthUnit();
            if (quantity == null) {
                throw new FDSRecordFormatException(rec, "QUANTITY must be specified.");
            }
            SlcfRecord slcfRec = new SlcfRecord(xyzPlane, new UnitDouble(xyzValue, lengthU), quantity, useVector, dtsam);
            this.getContainer().getSlcfList().taskAdd(slcfRec).run();
            this.flagPyroTypeAffected(SlcfRecord.class);
        }
        catch (FDSRecordFormatException e) {
            err = true;
            caughtExc = e;
        }
        catch (NullPointerException e1) {
            err = true;
        }
        catch (ClassCastException e2) {
            err = true;
        }
        catch (ArrayIndexOutOfBoundsException e3) {
            err = true;
        }
        catch (Exception e4) {
            err = true;
        }
        if (err) {
            if (caughtExc != null) {
                throw caughtExc;
            }
            throw new FDSRecordFormatException(rec);
        }
        return true;
    }

    @Override
    public void done() {
    }

    private boolean containsUnsupportedRecords(FDSInputRecord record) {
        GasPhaseQuantitiesList quans;
        if (record.getValue("CB") != null || record.getValue("K_HIGH") != null || record.getValue("K_LOW") != null || record.getValue("MESH_NUMBER") != null || record.getValue("WRITE_XYZ") != null || record.getValue("XB") != null) {
            return true;
        }
        String quantity = (String)record.getValue("QUANTITY");
        return quantity != null && !(quans = new GasPhaseQuantitiesList()).contains(quantity);
    }
}

