/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.domain.PipeManager;
import pyrosim.legacy_2006_2.domain.PipeRecord;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;

public class PipeProcessor
extends AFDSRecordProcessor {
    private Unit d_timeUnit = FdsSISystem.getInstance().getTimeUnit();
    private Unit d_barUnit = FdsSISystem.getInstance().getPipePressureUnit();

    public PipeProcessor(FDSParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public String getFDSTypeParsed() {
        return "PIPE";
    }

    @Override
    public boolean process(FDSInputRecord rec) throws FDSRecordFormatException {
        boolean err = false;
        FDSRecordFormatException caughtExc = null;
        if (!rec.getType().equals("PIPE")) {
            return false;
        }
        try {
            Object delayO = rec.getValue("DELAY");
            Object pressureO = rec.getValue("PRESSURE");
            if (delayO == null && pressureO == null) {
                throw new FDSRecordFormatException("You must enter DELAY and/or PRESSURE for the PIPE record.");
            }
            UnitDouble delay = rec.extractDouble("DELAY", this.d_timeUnit, new UnitDouble(0.0, this.d_timeUnit), (UnitDoubleValueRange)PipeRecord.getValueRange("DELAY"));
            UnitDouble pressure = rec.extractDouble("PRESSURE", this.d_barUnit, null, (UnitDoubleValueRange)PipeRecord.getValueRange("PRESSURE"));
            PipeRecord pipeRec = new PipeRecord(delay, pressure);
            PipeManager pm = this.getContainer().getPipeManager();
            pm.taskRemove(pm.getPipeRecord(), pipeRec).run();
            this.flagPyroTypeAffected(PipeRecord.class);
        }
        catch (FDSRecordFormatException e) {
            caughtExc = e;
            err = true;
        }
        catch (ClassCastException e2) {
            err = true;
        }
        if (err) {
            if (caughtExc != null) {
                throw caughtExc;
            }
            throw new FDSRecordFormatException(rec);
        }
        return true;
    }

    @Override
    public void done() {
    }
}

