/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.util.Vector;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.domain.GasPhaseQuantitiesList;
import pyrosim.legacy_2006_2.domain.PL3DManager;
import pyrosim.legacy_2006_2.domain.PL3DRecord;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;

public class PL3DProcessor
extends AFDSRecordProcessor {
    public PL3DProcessor(FDSParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public String getFDSTypeParsed() {
        return "PL3D";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean process(FDSInputRecord rec) throws FDSRecordFormatException {
        boolean err = false;
        FDSRecordFormatException caughtExc = null;
        if (!"PL3D".equals(rec.getType())) {
            return false;
        }
        try {
            int m;
            int m2;
            Vector<Object> quantities;
            GasPhaseQuantitiesList phases = new GasPhaseQuantitiesList();
            Object quantitiesObj = rec.getValue("QUANTITIES");
            if (quantitiesObj != null) {
                if (quantitiesObj instanceof Vector) {
                    quantities = (Vector<Object>)quantitiesObj;
                } else {
                    if (!(quantitiesObj instanceof String)) throw new FDSRecordFormatException(rec, "QUANTITIES must be a list containing only Strings.");
                    quantities = new Vector<Object>();
                    quantities.add(quantitiesObj);
                }
            } else {
                quantities = new Vector<Object>();
            }
            String[] quantitiesOverrides = new String[5];
            for (m2 = 0; m2 < quantitiesOverrides.length; ++m2) {
                quantitiesOverrides[m2] = null;
            }
            for (m2 = 1; m2 <= 5; ++m2) {
                String value = (String)rec.getValue("QUANTITIES(" + m2 + ")");
                if (value == null) continue;
                if (!phases.contains(value)) throw new FDSRecordFormatException(rec, value + " is not a valid Gas Phase Quantity.");
                quantitiesOverrides[m2 - 1] = value;
            }
            assert (quantities != null);
            String[] quantitiesS = new String[5];
            for (m = 0; m < quantitiesS.length; ++m) {
                quantitiesS[m] = null;
            }
            for (m = 0; m < quantities.size(); ++m) {
                String quan = (String)quantities.get(m);
                if (!phases.contains(quan)) {
                    throw new FDSRecordFormatException(rec, quan + " is not a valid Gas Phase Quantity.");
                }
                quantitiesS[m] = quan;
            }
            for (m = 0; m < quantitiesOverrides.length; ++m) {
                String quantityOverride = quantitiesOverrides[m];
                if (quantityOverride == null) continue;
                quantitiesS[m] = quantityOverride;
            }
            int numQuans = 0;
            for (int m3 = 0; m3 < quantitiesS.length; ++m3) {
                String quan = quantitiesS[m3];
                if (quan == null) continue;
                ++numQuans;
            }
            PL3DRecord pl3dRecord = new PL3DRecord(null);
            pl3dRecord.setEnabled(true);
            if (numQuans > 0) {
                pl3dRecord.clearQuantities();
                for (int m4 = 0; m4 < quantitiesS.length; ++m4) {
                    String quan = quantitiesS[m4];
                    if (quan == null) continue;
                    pl3dRecord.addQuantity(quan);
                }
            }
            FdsSISystem si = FdsSISystem.getInstance();
            UnitDouble dtsam = rec.extractDouble("DTSAM", si.getTimeUnit(), null, (UnitDoubleValueRange)PL3DRecord.getValueRange("DTSAM"));
            pl3dRecord.setDTSam(dtsam);
            Boolean writeXYZ = (Boolean)rec.getValue("WRITE_XYZ");
            if (writeXYZ != null) {
                pl3dRecord.setWriteXYZ(writeXYZ);
            }
            PL3DManager pm = this.getContainer().getPL3DManager();
            pm.taskRemove(pm.getPL3DRecord(), pl3dRecord).run();
            this.flagPyroTypeAffected(PL3DRecord.class);
        }
        catch (ClassCastException e) {
            err = true;
        }
        catch (FDSRecordFormatException e) {
            caughtExc = e;
            err = true;
        }
        catch (Exception e) {
            err = true;
        }
        if (!err) return true;
        if (caughtExc == null) throw new FDSRecordFormatException(rec);
        throw caughtExc;
    }

    @Override
    public void done() {
    }
}

