/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.domain.IsofRecord;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class IsofProcessor
extends AFDSRecordProcessor {
    public IsofProcessor(FDSParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public String getFDSTypeParsed() {
        return "ISOF";
    }

    @Override
    public boolean process(FDSInputRecord rec) throws FDSRecordFormatException {
        boolean err = false;
        FDSRecordFormatException caughtExc = null;
        try {
            Unit unit;
            if (rec.getType() == null) {
                throw new Exception();
            }
            if (!"ISOF".equals(rec.getType())) {
                return false;
            }
            String quantity = (String)rec.getValue("QUANTITY");
            UnitDouble dtsam = null;
            Vector<UnitDouble> values = new Vector<UnitDouble>();
            if (quantity.equals("TEMPERATURE")) {
                unit = FdsSISystem.getInstance().getTempUnit();
            } else if (quantity.equals("HRRPUV")) {
                unit = FdsSISystem.getInstance().getHRRPUVUnit();
            } else if (quantity.equals("DENSITY")) {
                unit = FdsSISystem.getInstance().getDensityUnit();
            } else if (quantity.equals("MIXTURE_FRACTION")) {
                unit = FdsSISystem.getInstance().getMixFracUnit();
            } else {
                throw new FDSRecordFormatException(rec, "Only the following gas phase quantities are allowed for ISOF records in FDS:\nDENSITY\nTEMPERATURE\nHRRPUV\nMIXTURE_FRACTION");
            }
            Vector<String> valueKeys = new Vector<String>();
            String[] allKeys = rec.getKeys();
            int numKeys = allKeys.length;
            for (int i = 0; i < numKeys; ++i) {
                if (allKeys[i].startsWith("VALUE(")) {
                    valueKeys.add(allKeys[i]);
                }
                if (!allKeys[i].equals("DTSAM")) continue;
                double value = (Double)rec.getValue(allKeys[i]);
                Unit timeUnit = FdsSISystem.getInstance().getTimeUnit();
                dtsam = new UnitDouble(value, timeUnit);
            }
            UnitDouble value = null;
            if (valueKeys.size() == 0) {
                throw new Exception();
            }
            for (int i = 0; i < valueKeys.size(); ++i) {
                Double tempValue = (Double)rec.getValue(valueKeys.elementAt(i).toString());
                value = new UnitDouble(tempValue, unit);
                values.add(value);
            }
            IsofRecord isofRec = new IsofRecord(values, quantity, dtsam);
            this.getContainer().getIsofList().taskAdd(isofRec).run();
            this.flagPyroTypeAffected(IsofRecord.class);
        }
        catch (NullPointerException e1) {
            err = true;
        }
        catch (ClassCastException e2) {
            err = true;
        }
        catch (ArrayIndexOutOfBoundsException e3) {
            err = true;
        }
        catch (FDSRecordFormatException e5) {
            caughtExc = e5;
            err = true;
        }
        catch (Exception e4) {
            err = true;
        }
        if (err) {
            if (caughtExc != null) {
                throw caughtExc;
            }
            throw new FDSRecordFormatException(rec);
        }
        return true;
    }

    @Override
    public void done() {
    }
}

