/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.awt.Color;
import java.util.Hashtable;
import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AlignedHole;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.EventParser;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class HoleProcessor
extends AFDSRecordProcessor {
    private Hashtable d_allHoles = new Hashtable(243);
    private int d_nextHoleNum = 1;

    public HoleProcessor(FDSParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public String getFDSTypeParsed() {
        return "HOLE";
    }

    @Override
    public boolean process(FDSInputRecord rec) throws FDSRecordFormatException {
        boolean err = false;
        if (!"HOLE".equals(rec.getType())) {
            return false;
        }
        Vector coords = null;
        try {
            AlignedHole correctHole;
            double temp;
            coords = (Vector)rec.getValue("XB");
            double minX = (Double)coords.get(0);
            double minY = (Double)coords.get(2);
            double minZ = (Double)coords.get(4);
            double maxX = (Double)coords.get(1);
            double maxY = (Double)coords.get(3);
            double maxZ = (Double)coords.get(5);
            if (maxX < minX) {
                temp = minX;
                minX = maxX;
                maxX = temp;
            }
            if (maxY < minY) {
                temp = minY;
                minY = maxY;
                maxY = temp;
            }
            if (maxZ < minZ) {
                temp = minZ;
                minZ = maxZ;
                maxZ = temp;
            }
            Unit u = FdsSISystem.getInstance().getLengthUnit();
            UnitPoint3D min = new UnitPoint3D(minX, minY, minZ, u);
            UnitPoint3D max = new UnitPoint3D(maxX, maxY, maxZ, u);
            String desc = rec.getComment();
            if (desc == null || desc.equals("")) {
                desc = new String("Hole #" + this.d_nextHoleNum++);
                while (this.d_allHoles.get(desc) != null) {
                    desc = new String("Hole #" + this.d_nextHoleNum++);
                }
            }
            AlignedHole hole = new AlignedHole(min, max, desc);
            Color color = this.parseColor(rec);
            if (color != null) {
                hole.setColor(color);
            }
            boolean usingExisting = (correctHole = (AlignedHole)EventParser.getCorrectObject(this.d_allHoles, hole)) != hole;
            hole = correctHole;
            String[] activateStrings = new String[]{"T_CREATE"};
            String[] deactivateStrings = new String[]{"T_REMOVE"};
            String heatActivateString = "HEAT_CREATE";
            String heatDeactivateString = "HEAT_REMOVE";
            EventParser.parseEvents(this, hole, rec, activateStrings, deactivateStrings, heatActivateString, heatDeactivateString, this.getContainer().getHeatDetectors());
            if (!usingExisting) {
                this.getContainer().getObstructions().taskAdd(hole).run();
                this.d_allHoles.put(hole.getPropertyHashString(), hole);
                this.flagPyroTypeAffected(AlignedHole.class);
            }
        }
        catch (NullPointerException e1) {
            e1.printStackTrace();
            err = true;
        }
        catch (ClassCastException e2) {
            e2.printStackTrace();
            err = true;
        }
        catch (ArrayIndexOutOfBoundsException e3) {
            e3.printStackTrace();
            err = true;
        }
        if (err) {
            throw new FDSRecordFormatException(rec);
        }
        return true;
    }

    @Override
    public void done() {
    }

    private UnitDouble makeDouble(Object value) {
        return new UnitDouble((Double)value, FdsSISystem.getInstance().getLengthUnit());
    }
}

