/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.util.Arrays;
import java.util.Vector;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.Rectifier;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.Grid;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.IntValueRange;

public class GridProcessor
extends AFDSRecordProcessor {
    private int d_iNextGridNumber = 1;
    private Vector d_gridInfos = new Vector();
    private TempGridInfo d_currentGridInfo;
    private Vector d_trnx = new Vector();
    private Vector d_trny = new Vector();
    private Vector d_trnz = new Vector();
    private boolean d_trnWarningShown = false;
    private static final String s_defGridName = "Grid";

    public GridProcessor(FDSParsingInfo parsingInfo) {
        super(parsingInfo);
        this.resetTempData();
    }

    @Override
    public String getFDSTypeParsed() {
        return "GRID";
    }

    @Override
    public boolean process(FDSInputRecord rec) throws FDSRecordFormatException {
        boolean err;
        block23: {
            err = false;
            try {
                if ("PDIM".equals(rec.getType())) {
                    Double temp;
                    String name;
                    if (this.d_currentGridInfo.d_haveBounds && this.d_currentGridInfo.d_haveNumDivisions) {
                        this.finishTempGridInfo();
                    }
                    if ((name = rec.getComment()) != null && !name.equals("")) {
                        this.d_currentGridInfo.d_gridName = name;
                    }
                    if ((temp = (Double)rec.getValue("XBAR0")) != null) {
                        this.d_currentGridInfo.d_min.x = temp;
                    }
                    if ((temp = (Double)rec.getValue("YBAR0")) != null) {
                        this.d_currentGridInfo.d_min.y = temp;
                    }
                    if ((temp = (Double)rec.getValue("ZBAR0")) != null) {
                        this.d_currentGridInfo.d_min.z = temp;
                    }
                    this.d_currentGridInfo.d_max.x = (Double)rec.getValue("XBAR");
                    this.d_currentGridInfo.d_max.y = (Double)rec.getValue("YBAR");
                    this.d_currentGridInfo.d_max.z = (Double)rec.getValue("ZBAR");
                    Rectifier.rectify(this.d_currentGridInfo.d_min, this.d_currentGridInfo.d_max);
                    this.d_currentGridInfo.d_haveBounds = true;
                    break block23;
                }
                if ("GRID".equals(rec.getType())) {
                    String name;
                    if (this.d_currentGridInfo.d_haveBounds && this.d_currentGridInfo.d_haveNumDivisions) {
                        this.finishTempGridInfo();
                    }
                    if ((name = rec.getComment()) != null && !name.equals("")) {
                        this.d_currentGridInfo.d_gridName = name;
                    }
                    this.d_currentGridInfo.d_xDiv = rec.extractInt("IBAR", 2, (IntValueRange)Grid.getValueRange("IBAR"), false);
                    this.d_currentGridInfo.d_yDiv = rec.extractInt("JBAR", 2, (IntValueRange)Grid.getValueRange("JBAR"), false);
                    this.d_currentGridInfo.d_zDiv = rec.extractInt("KBAR", 2, (IntValueRange)Grid.getValueRange("KBAR"), false);
                    this.d_currentGridInfo.d_haveNumDivisions = true;
                    break block23;
                }
                if ("TRNX".equals(rec.getType())) {
                    double cc = (Double)rec.getValue("CC");
                    double pc = (Double)rec.getValue("PC");
                    Double gridIndexI = (Double)rec.getValue("MESH_NUMBER");
                    if (gridIndexI == null) {
                        gridIndexI = this.d_gridInfos.size() + 1;
                        rec.setValue("MESH_NUMBER", gridIndexI);
                    }
                    int gridIndex = gridIndexI.intValue();
                    Double ideriv = (Double)rec.getValue("IDERIV");
                    if (ideriv != null) {
                        return false;
                    }
                    this.d_trnx.add(new TRNCard(this, cc, pc, gridIndex, rec));
                    break block23;
                }
                if ("TRNY".equals(rec.getType())) {
                    double cc = (Double)rec.getValue("CC");
                    double pc = (Double)rec.getValue("PC");
                    Double gridIndexI = (Double)rec.getValue("MESH_NUMBER");
                    if (gridIndexI == null) {
                        gridIndexI = this.d_gridInfos.size() + 1;
                        rec.setValue("MESH_NUMBER", gridIndexI);
                    }
                    int gridIndex = gridIndexI.intValue();
                    Double ideriv = (Double)rec.getValue("IDERIV");
                    if (ideriv != null) {
                        return false;
                    }
                    this.d_trny.add(new TRNCard(this, cc, pc, gridIndex, rec));
                    break block23;
                }
                if ("TRNZ".equals(rec.getType())) {
                    double cc = (Double)rec.getValue("CC");
                    double pc = (Double)rec.getValue("PC");
                    Double gridIndexI = (Double)rec.getValue("MESH_NUMBER");
                    if (gridIndexI == null) {
                        gridIndexI = this.d_gridInfos.size() + 1;
                        rec.setValue("MESH_NUMBER", gridIndexI);
                    }
                    int gridIndex = gridIndexI.intValue();
                    Double ideriv = (Double)rec.getValue("IDERIV");
                    if (ideriv != null) {
                        return false;
                    }
                    this.d_trnz.add(new TRNCard(this, cc, pc, gridIndex, rec));
                    break block23;
                }
                return false;
            }
            catch (NullPointerException e) {
                err = true;
            }
            catch (ClassCastException e2) {
                err = true;
            }
            catch (ArrayIndexOutOfBoundsException e3) {
                err = true;
            }
        }
        if (err) {
            throw new FDSRecordFormatException(rec);
        }
        return true;
    }

    @Override
    public void done() throws FDSRecordFormatException {
        if (this.d_currentGridInfo.d_haveBounds && this.d_currentGridInfo.d_haveNumDivisions) {
            this.finishTempGridInfo();
        }
        this.createGrids();
    }

    private void resetTempData() {
        this.d_currentGridInfo = new TempGridInfo();
    }

    private void finishTempGridInfo() {
        this.d_gridInfos.add(this.d_currentGridInfo);
        this.resetTempData();
    }

    private void checkTempGridInfoTRNCards() throws FDSRecordFormatException {
        for (int m = 0; m < this.d_gridInfos.size(); ++m) {
            int index;
            TRNCard card;
            int n;
            double lastCC;
            double lastPC;
            TempGridInfo info = (TempGridInfo)this.d_gridInfos.get(m);
            if (info.d_trnx.size() > 0) {
                lastPC = ((TRNCard)info.d_trnx.get((int)0)).pc;
                lastCC = ((TRNCard)info.d_trnx.get((int)0)).cc;
                for (n = 1; n < info.d_trnx.size(); ++n) {
                    card = (TRNCard)info.d_trnx.get(n);
                    index = card.d_gridIndex;
                    if (card.cc < lastCC || card.pc < lastPC) {
                        throw new FDSRecordFormatException(card.d_rec, "The TRNX records for grid number " + index + " are specified out of order. For each TRNX\nrecord applied to the same grid, CC and PC must increase.");
                    }
                    if (card.cc == lastCC || card.pc == lastPC) {
                        throw new FDSRecordFormatException(card.d_rec, "The TRNX records for grid number " + index + " are specified incorrectly. For each TRNX\nrecord applied to the same grid, CC and PC must increase.");
                    }
                    lastPC = card.pc;
                    lastCC = card.cc;
                }
            }
            if (info.d_trny.size() > 0) {
                lastPC = ((TRNCard)info.d_trny.get((int)0)).pc;
                lastCC = ((TRNCard)info.d_trny.get((int)0)).cc;
                for (n = 1; n < info.d_trny.size(); ++n) {
                    card = (TRNCard)info.d_trny.get(n);
                    index = card.d_gridIndex;
                    if (card.cc < lastCC || card.pc < lastPC) {
                        throw new FDSRecordFormatException(card.d_rec, "The TRNY records for grid number " + index + " are specified out of order. For each TRNY\nrecord applied to the same grid, CC and PC must increase.");
                    }
                    if (card.cc == lastCC || card.pc == lastPC) {
                        throw new FDSRecordFormatException(card.d_rec, "The TRNY records for grid number " + index + " are specified incorrectly. For each TRNY\nrecord applied to the same grid, CC and PC must increase.");
                    }
                    lastPC = card.pc;
                    lastCC = card.cc;
                }
            }
            if (info.d_trnz.size() <= 0) continue;
            lastPC = ((TRNCard)info.d_trnz.get((int)0)).pc;
            lastCC = ((TRNCard)info.d_trnz.get((int)0)).cc;
            for (n = 1; n < info.d_trnz.size(); ++n) {
                card = (TRNCard)info.d_trnz.get(n);
                index = card.d_gridIndex;
                if (card.cc < lastCC || card.pc < lastPC) {
                    throw new FDSRecordFormatException(card.d_rec, "The TRNZ records for grid number " + index + " are specified out of order. For each TRNZ\nrecord applied to the same grid, CC and PC must increase.");
                }
                if (card.cc == lastCC || card.pc == lastPC) {
                    throw new FDSRecordFormatException(card.d_rec, "The TRNZ records for grid number " + index + " are specified incorrectly. For each TRNZ\nrecord applied to the same grid, CC and PC must increase.");
                }
                lastPC = card.pc;
                lastCC = card.cc;
            }
        }
    }

    private void applyTRNCards() throws FDSRecordFormatException {
        double pc;
        double cc;
        TempGridInfo gridInfo;
        int index;
        TRNCard card;
        int m;
        for (m = 0; m < this.d_trnx.size(); ++m) {
            card = (TRNCard)this.d_trnx.get(m);
            index = card.d_gridIndex;
            if (index > this.d_gridInfos.size() || index <= 0) {
                throw new FDSRecordFormatException(card.d_rec, "The grid number, " + index + ", is invalid.  It must be from 1 to " + this.d_gridInfos.size() + " for this model.");
            }
            gridInfo = (TempGridInfo)this.d_gridInfos.get(index - 1);
            cc = card.cc;
            pc = card.pc;
            if (cc <= gridInfo.d_min.x || cc >= gridInfo.d_max.x) {
                throw new FDSRecordFormatException(card.d_rec, "The computational coordinate (CC) for scaling grid number " + index + " is invalid.  It must be between " + gridInfo.d_min.x + " and " + gridInfo.d_max.x + " (non-inclusive).");
            }
            if (pc <= gridInfo.d_min.x || pc >= gridInfo.d_max.x) {
                throw new FDSRecordFormatException(card.d_rec, "The physical coordinate (PC) for scaling grid number " + index + " is invalid.  It must be between " + gridInfo.d_min.x + " and " + gridInfo.d_max.x + " (non-inclusive).");
            }
            gridInfo.d_trnx.add(card);
            gridInfo.d_nonUniform = true;
        }
        for (m = 0; m < this.d_trny.size(); ++m) {
            card = (TRNCard)this.d_trny.get(m);
            index = card.d_gridIndex;
            if (index > this.d_gridInfos.size() || index <= 0) {
                throw new FDSRecordFormatException(card.d_rec, "The grid number, " + index + ", is invalid.  It must be from 1 to " + this.d_gridInfos.size() + " for this model.");
            }
            gridInfo = (TempGridInfo)this.d_gridInfos.get(index - 1);
            cc = card.cc;
            pc = card.pc;
            if (cc <= gridInfo.d_min.y || cc >= gridInfo.d_max.y) {
                throw new FDSRecordFormatException(card.d_rec, "The computational coordinate (CC) for scaling grid number " + index + " is invalid.  It must be between " + gridInfo.d_min.y + " and " + gridInfo.d_max.y + " (non-inclusive).");
            }
            if (pc <= gridInfo.d_min.y || pc >= gridInfo.d_max.y) {
                throw new FDSRecordFormatException(card.d_rec, "The physical coordinate (PC) for scaling grid number " + index + " is invalid.  It must be between " + gridInfo.d_min.y + " and " + gridInfo.d_max.y + " (non-inclusive).");
            }
            gridInfo.d_trny.add(card);
            gridInfo.d_nonUniform = true;
        }
        for (m = 0; m < this.d_trnz.size(); ++m) {
            card = (TRNCard)this.d_trnz.get(m);
            index = card.d_gridIndex;
            if (index > this.d_gridInfos.size() || index <= 0) {
                throw new FDSRecordFormatException(card.d_rec, "The grid number, " + index + ", is invalid.  It must be from 1 to " + this.d_gridInfos.size() + " for this model.");
            }
            gridInfo = (TempGridInfo)this.d_gridInfos.get(index - 1);
            if (gridInfo.d_trnx.size() > 0 && gridInfo.d_trny.size() > 0) {
                throw new FDSRecordFormatException(card.d_rec, "Grid scalings have been specified along all three axes for grid number " + index + ", but FDS4 only allows\nscaling along two axes.");
            }
            cc = card.cc;
            pc = card.pc;
            if (cc <= gridInfo.d_min.z || cc >= gridInfo.d_max.z) {
                throw new FDSRecordFormatException(card.d_rec, "The computational coordinate (CC) for scaling grid number " + index + " is invalid.  It must be between " + gridInfo.d_min.z + " and " + gridInfo.d_max.z + " (non-inclusive).");
            }
            if (pc <= gridInfo.d_min.z || pc >= gridInfo.d_max.z) {
                throw new FDSRecordFormatException(card.d_rec, "The physical coordinate (PC) for scaling grid number " + index + " is invalid.  It must be between " + gridInfo.d_min.z + " and " + gridInfo.d_max.z + " (non-inclusive).");
            }
            gridInfo.d_trnz.add(card);
            gridInfo.d_nonUniform = true;
        }
        this.checkTempGridInfoTRNCards();
    }

    private void createGrids() throws FDSRecordFormatException {
        this.applyTRNCards();
        Unit u = FdsSISystem.getInstance().getLengthUnit();
        for (int m = 0; m < this.d_gridInfos.size(); ++m) {
            TempGridInfo gridInfo = (TempGridInfo)this.d_gridInfos.get(m);
            Grid grid = null;
            UnitPoint3D minPt = new UnitPoint3D(gridInfo.d_min, u);
            UnitPoint3D maxPt = new UnitPoint3D(gridInfo.d_max, u);
            if (gridInfo.d_nonUniform) {
                System.out.println("Creating a non-uniform grid...");
                UnitDouble[] xs = null;
                UnitDouble[] ys = null;
                UnitDouble[] zs = null;
                xs = gridInfo.d_trnx.size() != 0 ? this.makeNonUniformDivisions(gridInfo.d_trnx, minPt.x(u), maxPt.x(u), gridInfo.d_xDiv) : Grid.makeUniformDivisions(gridInfo.d_xDiv, minPt.xu(), maxPt.xu());
                ys = gridInfo.d_trny.size() != 0 ? this.makeNonUniformDivisions(gridInfo.d_trny, minPt.y(u), maxPt.y(u), gridInfo.d_yDiv) : Grid.makeUniformDivisions(gridInfo.d_yDiv, minPt.yu(), maxPt.yu());
                zs = gridInfo.d_trnz.size() != 0 ? this.makeNonUniformDivisions(gridInfo.d_trnz, minPt.z(u), maxPt.z(u), gridInfo.d_zDiv) : Grid.makeUniformDivisions(gridInfo.d_zDiv, minPt.zu(), maxPt.zu());
                grid = new Grid(minPt, maxPt, xs, ys, zs, gridInfo.d_gridName);
            } else {
                System.out.println("Creating a uniform grid...");
                grid = new Grid(minPt, maxPt, gridInfo.d_xDiv, gridInfo.d_yDiv, gridInfo.d_zDiv, gridInfo.d_gridName);
            }
            this.makeUnique(grid, Grid.class);
            this.getContainer().getGridManager().taskAdd(grid).run();
            this.flagPyroTypeAffected(Grid.class);
        }
        this.resetTempData();
    }

    private UnitDouble[] makeNonUniformDivisions(Vector points, double min, double max, int numDiv) {
        Unit length = FdsSISystem.getInstance().getLengthUnit();
        Object[] divs = new UnitDouble[numDiv];
        int numOldCells = 0;
        double oldPC = min;
        double oldCC = min;
        double cellWid = 0.0;
        int numCells = 0;
        for (int i = 0; i < points.size(); ++i) {
            TRNCard pt = (TRNCard)points.get(i);
            numCells = (int)Math.round((pt.cc - oldCC) / (max - min) * (double)numDiv);
            cellWid = (pt.pc - oldPC) / (double)numCells;
            Arrays.fill(divs, numOldCells, numOldCells + numCells, new UnitDouble(cellWid, length));
            oldPC = pt.pc;
            oldCC = pt.cc;
            numOldCells += numCells;
        }
        numCells = numDiv - numOldCells;
        cellWid = (max - oldPC) / (double)numCells;
        Arrays.fill(divs, numOldCells, numOldCells + numCells, new UnitDouble(cellWid, length));
        return divs;
    }

    private static class TempGridInfo {
        public boolean d_haveBounds = false;
        public boolean d_haveNumDivisions = false;
        public boolean d_haveSpacing = false;
        public boolean d_nonUniform = false;
        public Point3d d_min = new Point3d(0.0, 0.0, 0.0);
        public Point3d d_max = new Point3d(0.0, 0.0, 0.0);
        public int d_xDiv = 1;
        public int d_yDiv = 1;
        public int d_zDiv = 1;
        public String d_gridName = "Grid";
        public Vector d_trnx = new Vector();
        public Vector d_trny = new Vector();
        public Vector d_trnz = new Vector();
    }

    private class TRNCard {
        public final FDSInputRecord d_rec;
        public final double cc;
        public final double pc;
        public final int d_gridIndex;

        public TRNCard(GridProcessor gridProcessor, double ccVal, double pcVal, int gridIndex, FDSInputRecord record) {
            this.cc = ccVal;
            this.pc = pcVal;
            this.d_gridIndex = gridIndex;
            this.d_rec = record;
        }
    }
}

