/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.TextureInfo;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.Primitive;

public class GE1File {
    public static boolean writeFile(String filename, PyroMod mod) throws IOException {
        Geometry g = new Geometry();
        mod.getObstructions().getGeometry(g);
        Map<Material, GE1Appearance> mats = GE1File.collectFaceMats(mod, g);
        if (mats.isEmpty()) {
            return false;
        }
        GE1Appearance[] appearances = mats.values().toArray(new GE1Appearance[mats.size()]);
        for (int m = 0; m < appearances.length; ++m) {
            appearances[m].d_index = m;
        }
        PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(filename)));
        GE1File.writeAppearances(writer, appearances);
        GE1File.writeFaces(writer, g, mats);
        writer.close();
        return true;
    }

    private static Map<Material, GE1Appearance> collectFaceMats(PyroMod mod, Geometry g) {
        HashMap<Material, GE1Appearance> mats = new HashMap<Material, GE1Appearance>(mod.getMaterials().size());
        GE1File.collectPrimMats(g.getQuads(), mats);
        GE1File.collectPrimMats(g.getTriangles(), mats);
        return mats;
    }

    private static void collectPrimMats(Collection<? extends Primitive> prims, Map<Material, GE1Appearance> matAppMap) {
        for (Primitive primitive : prims) {
            Material mat = primitive.getProps().getMaterial();
            if (mat == null) continue;
            GE1Appearance app = new GE1Appearance(mat);
            matAppMap.put(mat, app);
        }
    }

    private static void writeAppearances(PrintWriter writer, GE1Appearance[] appearances) {
        Unit lu = FdsSISystem.getInstance().getLengthUnit();
        writer.println("[APPEARANCE]");
        writer.println(appearances.length);
        float[] color = new float[4];
        for (GE1Appearance appearance : appearances) {
            String texname;
            double height;
            double width;
            Material mat = appearance.d_mat;
            writer.println(mat.getName());
            Color c = mat.getColor();
            TextureInfo texinfo = mat.getTextureInfo();
            if (texinfo != null) {
                width = texinfo.getWidth().getValue(lu);
                height = texinfo.getHeight().getValue(lu);
                texname = texinfo.getTexID();
            } else {
                height = 0.0;
                width = 0.0;
                texname = "";
            }
            c.getComponents(color);
            writer.printf("%d %f %f %f %f %f\n", appearance.d_index, Float.valueOf(color[0]), Float.valueOf(color[1]), Float.valueOf(color[2]), width, height);
            writer.println(texname);
        }
    }

    private static void writeFaces(PrintWriter writer, Geometry g, Map<Material, GE1Appearance> appearances) {
        writer.println("[FACES]");
        writer.println(g.getQuads().size() + g.getTriangles().size());
        GE1File.writePrims(writer, g.getQuads(), appearances, 4);
        GE1File.writePrims(writer, g.getTriangles(), appearances, 3);
    }

    private static void writePrims(PrintWriter writer, Collection<? extends Primitive> prims, Map<Material, GE1Appearance> appearances, int numPoints) {
        int numWriteLast = 4 - numPoints + 1;
        if (numWriteLast <= 0) {
            return;
        }
        int lastIx = numPoints - 1;
        for (Primitive primitive : prims) {
            Material mat = primitive.getProps().getMaterial();
            if (mat == null) continue;
            Point3d[] points = primitive.getPoints();
            assert (points.length == numPoints);
            for (int m = 0; m < lastIx; ++m) {
                Point3d p = points[m];
                writer.printf("%f %f %f ", p.x, p.y, p.z);
            }
            Point3d last = points[lastIx];
            for (int m = 0; m < numWriteLast; ++m) {
                writer.printf("%f %f %f ", last.x, last.y, last.z);
            }
            GE1Appearance app = appearances.get(mat);
            assert (app != null);
            writer.println(app.d_index);
        }
    }

    private static class GE1Appearance {
        private final Material d_mat;
        private int d_index;

        public GE1Appearance(Material mat) {
            assert (mat != null);
            this.d_mat = mat;
        }
    }
}

