/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.io;

import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import pyrosim.legacy_2006_2.io.AFDSRecordProcessor;
import pyrosim.legacy_2006_2.io.FDSInputFile;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.io.FDSRecordFormatException;
import pyrosim.legacy_2006_2.thunderheadeng.gui.guiFileChooser;

public class DatabaseProcessor
extends AFDSRecordProcessor {
    public DatabaseProcessor(FDSParsingInfo parsingInfo) {
        super(parsingInfo);
    }

    @Override
    public String getFDSTypeParsed() {
        return "DATABASE_RECORD";
    }

    @Override
    public boolean process(FDSInputRecord rec) throws FDSRecordFormatException {
        boolean err;
        FDSRecordFormatException caughtExc;
        block10: {
            if (!"MISC".equals(rec.getType())) {
                return false;
            }
            caughtExc = null;
            err = false;
            try {
                boolean alreadyParsed;
                String databaseDir;
                String currentFile = this.getParsingInfo().getCurrentParsingFile();
                String database = DatabaseProcessor.getAbsolutePath(currentFile, (String)rec.getValue("DATABASE"));
                if (database == null && (databaseDir = DatabaseProcessor.getAbsolutePath(currentFile, (String)rec.getValue("DATABASE_DIRECTORY"))) != null) {
                    database = new File(databaseDir, "database4.data").getAbsolutePath();
                }
                if ((database = this.checkDatabaseFile(database, rec)) == null || (alreadyParsed = this.getParsingInfo().fileParsingHasStarted(database))) break block10;
                FDSInputFile newInputFile = new FDSInputFile();
                try {
                    newInputFile.parseFile(database, this.getParsingInfo());
                }
                catch (IOException e) {
                    throw new FDSRecordFormatException(rec, "A file I/O exception occurred when processing " + database);
                }
            }
            catch (ClassCastException e) {
                err = true;
            }
            catch (NullPointerException e) {
                err = true;
            }
            catch (FDSRecordFormatException e) {
                err = true;
                caughtExc = e;
            }
        }
        if (err) {
            if (caughtExc != null) {
                throw caughtExc;
            }
            throw new FDSRecordFormatException(rec);
        }
        return false;
    }

    private String checkDatabaseFile(String databaseFile, FDSInputRecord rec) throws FDSRecordFormatException {
        File f;
        boolean fileOkay = true;
        String newDatabase = databaseFile;
        if (databaseFile != null && !(f = new File(databaseFile)).exists()) {
            int option = JOptionPane.showConfirmDialog(null, "The specified database file, \"" + databaseFile + ",\"\ndoes not exist.  Press \"OK\" to select another database or press \"Cancel\" to stop reading.", "Invalid Database", 2);
            if (option == 2) {
                fileOkay = false;
            } else {
                guiFileChooser dbChooser = new guiFileChooser("data", "Database File");
                String strCpf = this.getParsingInfo().getCurrentParsingFile();
                if (strCpf == null) {
                    strCpf = "";
                }
                File cpf = new File(strCpf);
                File dir = cpf.getParentFile();
                dbChooser.setCurrentDirectory(dir);
                int selection = dbChooser.showOpenDialog(null);
                if (selection != 0) {
                    fileOkay = false;
                } else {
                    File selectedFile = dbChooser.getSelectedFile();
                    newDatabase = selectedFile.getAbsolutePath();
                }
            }
        }
        if (!fileOkay) {
            throw new FDSRecordFormatException(rec, "The database file, \"" + databaseFile + ",\" does not exist.");
        }
        return newDatabase;
    }

    public static String getAbsolutePath(String sourceFile, String databaseFile) {
        File dbFile;
        String retDatabaseDir = databaseFile;
        if (sourceFile != null && databaseFile != null && !(dbFile = new File(databaseFile)).isAbsolute()) {
            File parseFile = new File(sourceFile);
            String parseFileParentPath = parseFile.getParentFile().getAbsolutePath();
            retDatabaseDir = new File(parseFileParentPath, databaseFile).getAbsolutePath();
        }
        return retDatabaseDir;
    }

    @Override
    public void done() throws FDSRecordFormatException {
    }
}

