/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.geom;

import java.io.Serializable;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.PrimProps;
import pyrosim.legacy_2006_2.geom.Primitive;
import pyrosim.legacy_2006_2.geom.Prism;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.Point3D;

public class Quad
implements Serializable,
Cloneable,
Primitive {
    static final long serialVersionUID = 1L;
    private Point3d[] d_points;
    private Vector3d d_normal;
    private PrimProps d_props = new PrimProps();

    public Quad(double[] coords, PrimProps sp) {
        this(coords, null, sp);
    }

    public Quad(double[] coords, Vector3d normal, PrimProps sp) {
        if (coords.length != 12) {
            throw new IllegalArgumentException("This Quad construction requires 12 coordinates (p0.x, p0.y, p0.z, p1.x, ..., p3.z).");
        }
        this.init(new Point3d[]{new Point3d(coords[0], coords[1], coords[2]), new Point3d(coords[3], coords[4], coords[5]), new Point3d(coords[6], coords[7], coords[8]), new Point3d(coords[9], coords[10], coords[11])}, normal, sp);
    }

    public Quad(Point3d p0, Point3d p1, Point3d p2, Point3d p3, PrimProps sp) {
        this.init(new Point3d[]{p0, p1, p2, p3}, null, sp);
    }

    public Quad(Point3d p0, Point3d p1, Point3d p2, Point3d p3, Vector3d normal, PrimProps sp) {
        this.init(new Point3d[]{p0, p1, p2, p3}, normal, sp);
    }

    public Quad(Point3d[] points, PrimProps sp) {
        this.init(points, null, sp);
    }

    public Quad(Point3d[] points, Vector3d normal, PrimProps sp) {
        this.init(points, normal, sp);
    }

    private void init(Point3d[] points, Vector3d normal, PrimProps sp) {
        if (points.length != 4) {
            throw new IllegalArgumentException("Quad must have 4 points.");
        }
        this.d_points = points;
        this.d_normal = normal != null ? normal : Geometry.calcNormal(points[0], points[1], points[2]);
        this.d_props = sp;
    }

    public static Quad fromLegacy(pyrosim.legacy_2006_2.legacy.v17.Quad q) {
        Point3d[] points = new Point3d[4];
        for (int m = 0; m < 4; ++m) {
            Point3D oldPoint = q.getPoint(m);
            points[m] = new Point3d(oldPoint.x, oldPoint.y, oldPoint.z);
        }
        Quad newq = new Quad(points, new PrimProps(null, q.getColor()));
        return newq;
    }

    public boolean equals(Object obj) {
        int ip;
        if (!(obj instanceof Quad)) {
            return false;
        }
        Quad q = (Quad)obj;
        Point3d p = this.getPoint(0);
        for (ip = 0; ip < 4 && !p.equals(q.getPoint(ip)); ++ip) {
        }
        if (ip >= 4) {
            return false;
        }
        int offset = ip;
        for (ip = 1; ip < 4; ++ip) {
            if (this.getPoint(ip).equals(q.getPoint((ip + offset) % 4))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Vector3d getNormal() {
        return this.d_normal;
    }

    public boolean isParallelZ() {
        return this.getPoint((int)0).z == this.getPoint((int)1).z && this.getPoint((int)0).z == this.getPoint((int)2).z && this.getPoint((int)0).z == this.getPoint((int)3).z;
    }

    public boolean isParallelX() {
        return this.getPoint((int)0).x == this.getPoint((int)1).x && this.getPoint((int)0).x == this.getPoint((int)2).x && this.getPoint((int)0).x == this.getPoint((int)3).x;
    }

    public boolean isParallelY() {
        return this.getPoint((int)0).y == this.getPoint((int)1).y && this.getPoint((int)0).y == this.getPoint((int)2).y && this.getPoint((int)0).y == this.getPoint((int)3).y;
    }

    public Point3d getPoint(int index) {
        return this.d_points[index];
    }

    @Override
    public Point3d[] getPoints() {
        return this.d_points;
    }

    public void setPoints(Point3d[] points) {
        this.d_points = points;
        this.d_normal = Geometry.calcNormal(points[0], points[1], points[2]);
    }

    @Override
    public PrimProps getProps() {
        return this.d_props;
    }

    @Override
    public void setProps(PrimProps p) {
        this.d_props = p;
    }

    public void translate(double dx, double dy, double dz) {
        for (int i = 0; i < this.d_points.length; ++i) {
            this.d_points[i].x += dx;
            this.d_points[i].y += dy;
            this.d_points[i].z += dz;
        }
    }

    public void flipNormal() {
        Point3d temp = this.d_points[1];
        this.d_points[1] = this.d_points[3];
        this.d_points[3] = temp;
    }

    public Prism extrudeAlongNormal(double amount) {
        double halfAmount = amount * 0.5;
        double minX = this.d_points[0].x;
        double maxX = this.d_points[2].x;
        double minY = this.d_points[0].y;
        double maxY = this.d_points[2].y;
        double minZ = this.d_points[0].z;
        double maxZ = this.d_points[2].z;
        if (this.isParallelX()) {
            minX -= halfAmount;
            maxX += halfAmount;
        } else if (this.isParallelY()) {
            minY -= halfAmount;
            maxY += halfAmount;
        } else if (this.isParallelZ()) {
            minZ -= halfAmount;
            maxZ += halfAmount;
        }
        return new Prism(minX, maxX, minY, maxY, minZ, maxZ);
    }

    public Object clone() {
        try {
            Quad q = (Quad)super.clone();
            q.d_points = new Point3d[]{new Point3d(this.d_points[0].x, this.d_points[0].y, this.d_points[0].z), new Point3d(this.d_points[1].x, this.d_points[1].y, this.d_points[1].z), new Point3d(this.d_points[2].x, this.d_points[2].y, this.d_points[2].z), new Point3d(this.d_points[3].x, this.d_points[3].y, this.d_points[3].z)};
            q.d_normal = (Vector3d)this.d_normal.clone();
            q.d_props = this.d_props != null ? (PrimProps)this.d_props.clone() : null;
            return q;
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
    }
}

