/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.geom;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.PrimProps;
import pyrosim.legacy_2006_2.geom.Primitive;

public class Polygon
implements Primitive {
    private Point3d[] d_points;
    private Vector3d d_normal;
    private PrimProps d_props = new PrimProps();

    public Polygon(PrimProps sp, Point3d ... points) {
        this.init(points, null, sp);
    }

    public Polygon(Vector3d normal, PrimProps sp, Point3d ... points) {
        this.init(points, normal, sp);
    }

    private void init(Point3d[] points, Vector3d normal, PrimProps sp) {
        assert (points.length >= 3);
        this.d_points = points;
        this.d_normal = normal != null ? normal : Geometry.calcNormal(points[0], points[1], points[2]);
        this.d_props = sp;
    }

    @Override
    public PrimProps getProps() {
        return this.d_props;
    }

    @Override
    public void setProps(PrimProps p) {
        this.d_props = p;
    }

    @Override
    public Point3d[] getPoints() {
        return this.d_points;
    }

    @Override
    public Vector3d getNormal() {
        return this.d_normal;
    }
}

