/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.geom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.geom.Line;
import pyrosim.legacy_2006_2.geom.Point;
import pyrosim.legacy_2006_2.geom.Primitive;
import pyrosim.legacy_2006_2.geom.Prism;
import pyrosim.legacy_2006_2.geom.Quad;
import pyrosim.legacy_2006_2.geom.Triangle;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.Point3D;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.nativebuffered.BoundingBox3D;

public class Geometry
implements Serializable {
    static final long serialVersionUID = 1L;
    private Collection<Quad> d_quads = new ArrayList<Quad>();
    private Collection<Triangle> d_tris = new ArrayList<Triangle>();
    private Collection<Line> d_lines = new ArrayList<Line>();
    private Collection<Point> d_points = new ArrayList<Point>();
    public static final Unit GEOM_LENGTH_UNIT = SI.METER;
    public static final Unit GEOM_ANGLE_UNIT = NonSI.DEGREE_ANGLE;
    public static final Tuple3d TUP3D_ZERO = new Point3d(0.0, 0.0, 0.0);
    public static final Vector3d VEC3D_XPOS = new Vector3d(1.0, 0.0, 0.0);
    public static final Vector3d VEC3D_XNEG = new Vector3d(-1.0, 0.0, 0.0);
    public static final Vector3d VEC3D_YPOS = new Vector3d(0.0, 1.0, 0.0);
    public static final Vector3d VEC3D_YNEG = new Vector3d(0.0, -1.0, 0.0);
    public static final Vector3d VEC3D_ZPOS = new Vector3d(0.0, 0.0, 1.0);
    public static final Vector3d VEC3D_ZNEG = new Vector3d(0.0, 0.0, -1.0);
    public static final Point3d PNT3D_XPOS = new Point3d(1.0, 0.0, 0.0);
    public static final Point3d PNT3D_XNEG = new Point3d(-1.0, 0.0, 0.0);
    public static final Point3d PNT3D_YPOS = new Point3d(0.0, 1.0, 0.0);
    public static final Point3d PNT3D_YNEG = new Point3d(0.0, -1.0, 0.0);
    public static final Point3d PNT3D_ZPOS = new Point3d(0.0, 0.0, 1.0);
    public static final Point3d PNT3D_ZNEG = new Point3d(0.0, 0.0, -1.0);

    public void addPrism(Prism p) {
        this.addQuadsFromPrism(p);
    }

    public void addPrisms(Collection<Prism> prisms) {
        for (Prism p : prisms) {
            this.addPrism(p);
        }
    }

    private void addQuadsFromPrism(Prism p) {
        for (int faceIndex = 0; faceIndex < 6; ++faceIndex) {
            this.addQuad(p.getFace(faceIndex));
        }
    }

    public void addQuad(Quad q) {
        this.d_quads.add(q);
    }

    public void addQuads(Collection<Quad> quads) {
        for (Quad q : quads) {
            this.addQuad(q);
        }
    }

    public void addTriangle(Triangle t) {
        this.d_tris.add(t);
    }

    public void addTriangles(Collection<Triangle> tris) {
        for (Triangle t : tris) {
            this.addTriangle(t);
        }
    }

    public void addLine(Line l) {
        this.d_lines.add(l);
    }

    public void addLines(Collection<Line> lines) {
        for (Line l : lines) {
            this.addLine(l);
        }
    }

    public void addPoint(Point p) {
        this.d_points.add(p);
    }

    public void addPoints(Collection<Point> points) {
        this.d_points.addAll(points);
    }

    public void addGeometry(Geometry g) {
        this.d_quads.addAll(g.getQuads());
        this.d_tris.addAll(g.getTriangles());
        this.d_lines.addAll(g.getLines());
        this.d_points.addAll(g.getPoints());
    }

    public void clear() {
        this.d_quads.clear();
        this.d_lines.clear();
        this.d_tris.clear();
        this.d_points.clear();
    }

    public Collection<Quad> getQuads() {
        return this.d_quads;
    }

    public Collection<Triangle> getTriangles() {
        return this.d_tris;
    }

    public Collection<Line> getLines() {
        return this.d_lines;
    }

    public Collection<Point> getPoints() {
        return this.d_points;
    }

    public BoundingBox3D getBounds() {
        BoundingBox3D bb = new BoundingBox3D();
        this.addPoints(bb, this.d_quads);
        this.addPoints(bb, this.d_tris);
        this.addPoints(bb, this.d_lines);
        this.addPoints(bb, this.d_points);
        return bb;
    }

    private void addPoints(BoundingBox3D bb, Collection<? extends Primitive> objs) {
        for (Primitive primitive : objs) {
            for (Point3d p : primitive.getPoints()) {
                bb.add(p);
            }
        }
    }

    public Point3D getMinPoint() {
        BoundingBox3D bb = new BoundingBox3D();
        this.addPointsForMin(bb, this.d_quads);
        this.addPointsForMin(bb, this.d_tris);
        this.addPointsForMin(bb, this.d_lines);
        this.addPointsForMin(bb, this.d_points);
        return new Point3D(bb.getMin());
    }

    public Point3D getMaxPoint() {
        BoundingBox3D bb = new BoundingBox3D();
        this.addPointsForMax(bb, this.d_quads);
        this.addPointsForMax(bb, this.d_tris);
        this.addPointsForMax(bb, this.d_lines);
        this.addPointsForMax(bb, this.d_points);
        return new Point3D(bb.getMax());
    }

    private void addPointsForMin(BoundingBox3D bb, Collection<? extends Primitive> objs) {
        for (Primitive primitive : objs) {
            for (Point3d p : primitive.getPoints()) {
                bb.addForMin(p);
            }
        }
    }

    private void addPointsForMax(BoundingBox3D bb, Collection<? extends Primitive> objs) {
        for (Primitive primitive : objs) {
            for (Point3d p : primitive.getPoints()) {
                bb.addForMax(p);
            }
        }
    }

    public static Vector3d calcNormal(Point3d p1, Point3d p2, Point3d p3) {
        Vector3d ref1 = new Vector3d();
        ref1.sub(p1, p2);
        Vector3d ref2 = new Vector3d();
        ref2.sub(p1, p3);
        Vector3d normal = new Vector3d();
        normal.cross(ref1, ref2);
        normal.normalize();
        return normal;
    }
}

