/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain.rasterization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.Grid;
import pyrosim.legacy_2006_2.domain.rasterization.FDSObjectRasterization;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.events.FDSRasterDomainEvent;
import pyrosim.legacy_2006_2.events.GridDomainEvent;
import pyrosim.legacy_2006_2.events.PyroModDomainEvent;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.Util;
import pyrosim.legacy_2006_2.thunderheadeng.gui.IDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.rasterization.Raster3D;
import pyrosim.legacy_2006_2.thunderheadeng.util.FilteredCollection;
import pyrosim.legacy_2006_2.thunderheadeng.util.TypeFilter;

public class FDSRasterization {
    private final Map<Grid, Raster3D<FDSObject>> d_gridRasterMap = new HashMap<Grid, Raster3D<FDSObject>>();
    private final Map<FDSObject, FDSObjectRasterization> d_objRasters = new HashMap<FDSObject, FDSObjectRasterization>();
    private final Set<FDSObject> d_unrastObjs = new HashSet<FDSObject>();
    private final FDSRasterDomainEvent d_events = new FDSRasterDomainEvent();
    private final PyroMod d_mediator;

    public FDSRasterization() {
        this(null);
    }

    public FDSRasterization(PyroMod mediator) {
        this.d_mediator = mediator;
    }

    public static int getCellPriority(boolean isHoleAndNotObj, boolean isFaceAndNotInterior, boolean permitsHoles) {
        if (isHoleAndNotObj) {
            return 2;
        }
        if (!permitsHoles) {
            if (isFaceAndNotInterior) {
                return 0;
            }
            return 1;
        }
        if (isFaceAndNotInterior) {
            return 3;
        }
        return 4;
    }

    public FDSRasterDomainEvent getEvents() {
        return this.d_events;
    }

    public void respondToEvents(IDomainEvent evt) {
        if (evt instanceof FDSObjectDomainEvent) {
            this.respondToEvent((FDSObjectDomainEvent)evt);
        } else if (evt instanceof GridDomainEvent) {
            this.respondToEvent((GridDomainEvent)evt);
        } else if (evt instanceof PyroModDomainEvent) {
            this.respondToEvent((PyroModDomainEvent)evt);
        }
    }

    private void respondToEvent(PyroModDomainEvent evt) {
        if (evt.isModelChanged()) {
            this.reset();
        }
    }

    private void respondToEvent(GridDomainEvent evt) {
        switch (evt.getEventType()) {
            case 3: {
                this.addRasters(evt.getObjects());
                break;
            }
            case 4: {
                this.removeRasters(evt.getObjects());
                break;
            }
            case 5: {
                this.updateRasters(evt.getObjects());
            }
        }
    }

    private void respondToEvent(FDSObjectDomainEvent evt) {
        FilteredCollection<FDSObject> shallowObjs = new FilteredCollection<FDSObject>(evt.getObjects(), new TypeFilter<FDSObject>(this, FDSObject.class){

            @Override
            public boolean shouldFilter(Object o) {
                return o instanceof FDSComposite;
            }
        });
        switch (evt.getEventType()) {
            case 3: {
                this.addObjects(shallowObjs);
                break;
            }
            case 4: {
                this.removeObjects(shallowObjs);
                break;
            }
            case 5: {
                this.updateObjects(shallowObjs);
                break;
            }
            case 0: {
                this.getEvents().objectsChanged((byte)2, this.getRasterizations(shallowObjs));
                break;
            }
            case 1: {
                this.getEvents().objectsChanged((byte)4, this.getRasterizations(shallowObjs));
            }
        }
    }

    private void reset() {
        this.d_events.objectsRemoved(this.d_objRasters.values());
        this.d_gridRasterMap.clear();
        this.d_objRasters.clear();
        this.d_unrastObjs.clear();
        System.gc();
        if (this.d_mediator != null) {
            this.addRasters(this.d_mediator.getGridManager().toCollection());
            this.addObjects(this.d_mediator.getObstructions().toCollection(FDSObject.class, true));
        }
    }

    public void clearObjs() {
        this.getEvents().objectsRemoved(this.d_objRasters.values());
        this.d_objRasters.clear();
        for (Raster3D<FDSObject> raster : this.d_gridRasterMap.values()) {
            raster.clear();
        }
        this.d_unrastObjs.clear();
    }

    private void syncRasterizableObjects() {
        ArrayList<FDSObject> oldRastObjs = new ArrayList<FDSObject>(this.d_objRasters.keySet());
        for (FDSObject oldRastObj : oldRastObjs) {
            if (oldRastObj.isRasterizable()) continue;
            this.removeObject(oldRastObj);
            this.d_unrastObjs.add(oldRastObj);
        }
        ArrayList<FDSObject> oldUnrastObjs = new ArrayList<FDSObject>(this.d_unrastObjs);
        for (FDSObject oldUnrastObj : oldUnrastObjs) {
            if (!oldUnrastObj.isRasterizable()) continue;
            this.d_unrastObjs.remove(oldUnrastObj);
            this.addObject(oldUnrastObj);
        }
    }

    public void addRasters(Collection<? extends Grid> grids) {
        Unit lu = Geometry.GEOM_LENGTH_UNIT;
        for (Grid grid : grids) {
            double[] xDiv = Util.convertArray(grid.getXLinePositions(), lu);
            double[] yDiv = Util.convertArray(grid.getYLinePositions(), lu);
            double[] zDiv = Util.convertArray(grid.getZLinePositions(), lu);
            Raster3D<FDSObject> raster = new Raster3D<FDSObject>(FDSObject.class, xDiv, yDiv, zDiv);
            this.d_gridRasterMap.put(grid, raster);
            for (FDSObjectRasterization objRaster : this.d_objRasters.values()) {
                objRaster.addGrid(grid, raster);
            }
        }
        this.syncRasterizableObjects();
    }

    public void removeRasters(Collection<? extends Grid> grids) {
        for (Grid grid : grids) {
            this.d_gridRasterMap.remove(grid);
            for (FDSObjectRasterization objRaster : this.d_objRasters.values()) {
                objRaster.removeGrid(grid);
            }
        }
        this.syncRasterizableObjects();
    }

    public void updateRasters(Collection<? extends Grid> grids) {
        if (grids.isEmpty()) {
            return;
        }
        Unit lu = Geometry.GEOM_LENGTH_UNIT;
        for (Grid grid : grids) {
            Raster3D<FDSObject> raster = this.d_gridRasterMap.get(grid);
            assert (raster != null);
            double[] xDiv = Util.convertArray(grid.getXLinePositions(), lu);
            double[] yDiv = Util.convertArray(grid.getYLinePositions(), lu);
            double[] zDiv = Util.convertArray(grid.getZLinePositions(), lu);
            raster.setDivisions(xDiv, yDiv, zDiv);
            for (FDSObjectRasterization objRaster : this.d_objRasters.values()) {
                objRaster.gridChanged(grid);
            }
        }
        this.syncRasterizableObjects();
    }

    public void addObjects(Collection<? extends FDSObject> objs) {
        for (FDSObject fDSObject : objs) {
            this.addObject(fDSObject);
        }
    }

    public boolean addObject(FDSObject obj) {
        if (!obj.isRasterizable()) {
            this.d_unrastObjs.add(obj);
            return false;
        }
        FDSObjectRasterization objRaster = new FDSObjectRasterization(obj, this.d_gridRasterMap, this);
        this.d_objRasters.put(obj, objRaster);
        this.d_events.objectAdded(objRaster);
        return true;
    }

    public void removeObjects(Collection<? extends FDSObject> objs) {
        for (FDSObject fDSObject : objs) {
            this.removeObject(fDSObject);
        }
    }

    public void removeObject(FDSObject obj) {
        FDSObjectRasterization objRaster = this.d_objRasters.remove(obj);
        if (objRaster != null) {
            objRaster.unrasterize();
            this.d_events.objectRemoved(objRaster);
        } else {
            this.d_unrastObjs.remove(obj);
        }
    }

    public void updateObjects(Collection<? extends FDSObject> objs) {
        for (FDSObject fDSObject : objs) {
            FDSObjectRasterization objRaster = this.d_objRasters.get(fDSObject);
            if (objRaster == null) {
                if (!fDSObject.isRasterizable()) continue;
                this.d_unrastObjs.remove(fDSObject);
                this.addObject(fDSObject);
                continue;
            }
            if (fDSObject.isRasterizable()) {
                objRaster.objChanged();
                continue;
            }
            this.removeObject(fDSObject);
            this.d_unrastObjs.add(fDSObject);
        }
    }

    public FDSRasterDomainEvent rasterizeObjects() {
        for (FDSObjectRasterization rast : this.d_objRasters.values()) {
            rast.rasterize();
        }
        return this.d_events;
    }

    public FDSObject[] getFrags(Grid g, boolean mergeCells) {
        Raster3D<FDSObject> raster = this.d_gridRasterMap.get(g);
        assert (raster != null);
        return raster.getFrags(mergeCells);
    }

    public Collection<FDSObject> getFrags(boolean mergeCells) {
        ArrayList<FDSObject> frags = new ArrayList<FDSObject>();
        for (Grid g : this.d_gridRasterMap.keySet()) {
            FDSObject[] gridFrags = this.getFrags(g, mergeCells);
            frags.addAll(Arrays.asList(gridFrags));
        }
        return frags;
    }

    public Collection<FDSObject> getFrags(Class type, boolean mergeCells) {
        Collection<FDSObject> frags = this.getFrags(mergeCells);
        return new FilteredCollection<FDSObject>(frags, type);
    }

    public Collection<Grid> getRasterGrids() {
        return this.d_gridRasterMap.keySet();
    }

    public Collection<FDSObject> getRasterObjects() {
        return this.d_objRasters.keySet();
    }

    public FDSObjectRasterization getRasterization(FDSObject obj) {
        return this.d_objRasters.get(obj);
    }

    public Collection<FDSObjectRasterization> getRasterizations(Collection<? extends FDSObject> objs) {
        ArrayList<FDSObjectRasterization> rasts = new ArrayList<FDSObjectRasterization>(objs.size());
        for (FDSObject fDSObject : objs) {
            FDSObjectRasterization rast = this.d_objRasters.get(fDSObject);
            if (rast == null) continue;
            rasts.add(rast);
        }
        return rasts;
    }
}

