/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain.rasterization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.vecmath.Point3d;
import javax.vecmath.Point3i;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.Grid;
import pyrosim.legacy_2006_2.domain.IFace;
import pyrosim.legacy_2006_2.domain.rasterization.FDSObjectRasterization;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.Util;
import pyrosim.legacy_2006_2.thunderheadeng.rasterization.ARasterization;
import pyrosim.legacy_2006_2.thunderheadeng.rasterization.IFragGenerator;
import pyrosim.legacy_2006_2.thunderheadeng.rasterization.Raster3D;

public class FDSObjGridRasterization {
    private final Grid d_grid;
    private final FDSObject d_obj;
    private final FDSObjectRasterization d_parentRast;
    private final Raster3D<FDSObject> d_raster;
    private ObjectRasterization d_interiorRasterization = null;
    private ObjectRasterization[] d_faceRasterizations = null;
    private boolean d_rasterDirty = true;
    private boolean d_updatesPaused = false;

    public FDSObjGridRasterization(FDSObject obj, Grid g, FDSObjectRasterization parentRast, Raster3D<FDSObject> raster) {
        this.d_parentRast = parentRast;
        this.d_grid = g;
        this.d_raster = raster;
        this.d_obj = obj;
    }

    protected void gridChanged() {
        this.d_rasterDirty = true;
        this.d_faceRasterizations = null;
        this.d_interiorRasterization = null;
    }

    protected void objChanged() {
        this.unrasterize();
        this.d_rasterDirty = true;
    }

    protected void rasterize() {
        if (this.d_rasterDirty) {
            Unit lu = Geometry.GEOM_LENGTH_UNIT;
            this.d_updatesPaused = true;
            this.d_faceRasterizations = new ObjectRasterization[this.d_obj.getNumFaces()];
            if (this.d_obj.isSolid()) {
                Point3d[][] polys = new Point3d[this.d_obj.getNumFaces()][];
                for (int m = 0; m < this.d_obj.getNumFaces(); ++m) {
                    IFace face = this.d_obj.getFace(m);
                    this.d_faceRasterizations[m] = new ObjectRasterization(face.getFDSFragGenerator());
                    UnitPoint3D[] unitVerts = face.getVerts();
                    polys[m] = Util.convertArray(lu, unitVerts);
                }
                this.d_interiorRasterization = new ObjectRasterization(this.d_obj.getInteriorFragGenerator());
                this.d_raster.rasterizeSolid(this.d_interiorRasterization, this.d_faceRasterizations, polys);
            } else {
                for (int m = 0; m < this.d_obj.getNumFaces(); ++m) {
                    IFace face = this.d_obj.getFace(m);
                    this.d_faceRasterizations[m] = new ObjectRasterization(face.getFDSFragGenerator());
                    UnitPoint3D[] unitVerts = face.getVerts();
                    Point3d[] verts = Util.convertArray(lu, unitVerts);
                    this.d_raster.rasterizeConvexPolygon(this.d_faceRasterizations[m], verts);
                }
                this.d_interiorRasterization = null;
            }
            this.d_updatesPaused = false;
            this.d_rasterDirty = false;
            this.fireChanged();
        }
    }

    protected void unrasterize() {
        if (this.d_faceRasterizations == null) {
            return;
        }
        this.d_updatesPaused = true;
        for (ObjectRasterization rast : this.d_faceRasterizations) {
            this.d_raster.removeRasterization(rast);
        }
        if (this.d_interiorRasterization != null) {
            this.d_raster.removeRasterization(this.d_interiorRasterization);
        }
        this.d_faceRasterizations = null;
        this.d_interiorRasterization = null;
        this.d_updatesPaused = false;
    }

    public ObjectRasterization getInteriorRasterization() {
        return this.d_interiorRasterization;
    }

    public ObjectRasterization[] getFaceRasterizations() {
        if (this.d_faceRasterizations == null) {
            return new ObjectRasterization[0];
        }
        return this.d_faceRasterizations;
    }

    public Collection<FDSObject> getFrags(boolean mergeCells) {
        ObjectRasterization[] rasts = this.getFaceRasterizations();
        ObjectRasterization interiorRast = this.getInteriorRasterization();
        ArrayList<ObjectRasterization> allRasts = new ArrayList<ObjectRasterization>(Arrays.asList(rasts));
        if (interiorRast != null) {
            allRasts.add(interiorRast);
        }
        return Arrays.asList(this.d_raster.getFrags(allRasts, mergeCells));
    }

    public int getNumCells() {
        int totalNumCells = 0;
        for (ObjectRasterization rast : this.getFaceRasterizations()) {
            totalNumCells += rast.getCells().size();
        }
        ObjectRasterization interiorRast = this.getInteriorRasterization();
        if (interiorRast != null) {
            totalNumCells += interiorRast.getCells().size();
        }
        return totalNumCells;
    }

    private void fireChanged() {
        if (this.d_updatesPaused) {
            return;
        }
        this.d_parentRast.fireChanged();
    }

    public class ObjectRasterization
    extends ARasterization<FDSObject> {
        private final IFDSFragGenerator d_fragGenerator;

        public ObjectRasterization(IFDSFragGenerator gen) {
            this.d_fragGenerator = gen;
        }

        @Override
        public IFragGenerator<? extends FDSObject> getFragGenerator() {
            return this.d_fragGenerator;
        }

        public IFDSFragGenerator getFDSFragGenerator() {
            return this.d_fragGenerator;
        }

        @Override
        public void addCell(Point3i cell) {
            super.addCell(cell);
            FDSObjGridRasterization.this.fireChanged();
        }

        @Override
        public void removeCell(Point3i cell) {
            super.removeCell(cell);
            FDSObjGridRasterization.this.fireChanged();
        }

        @Override
        public void clear() {
            super.clear();
            FDSObjGridRasterization.this.fireChanged();
        }
    }
}

