/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import pyrosim.legacy_2006_2.UnitPoint2D;
import pyrosim.legacy_2006_2.domain.AFDSFaceProps;
import pyrosim.legacy_2006_2.domain.AUnalignedFDSObject;
import pyrosim.legacy_2006_2.domain.IFace;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.rasterization.BlockFragGenerator;
import pyrosim.legacy_2006_2.domain.rasterization.FDSRasterization;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class Wall
extends AUnalignedFDSObject {
    static final long serialVersionUID = 1L;
    private boolean d_thicken = false;
    private boolean d_permitHole = true;
    private boolean d_sawtooth = true;

    public Wall(Material mat) {
        super(mat);
    }

    public Wall(String name, Material mat) {
        super(name, mat);
    }

    public Wall(UnitPoint2D a, UnitPoint2D b, UnitDouble bottom, UnitDouble top, UnitDouble thickness, Material mat) {
        super(a, b, bottom, top, thickness, "Obstruction", mat);
    }

    public Wall(UnitPoint2D a, UnitPoint2D b, UnitDouble bottom, UnitDouble top, UnitDouble thickness, String description, Material mat) {
        super(a, b, bottom, top, thickness, description, mat);
    }

    public static Wall fromLegacy(pyrosim.legacy_2006_2.legacy.v16.Wall oldWall) {
        Wall h = new Wall(oldWall.getMaterial());
        AUnalignedFDSObject.fromLegacy(oldWall, h);
        h.d_permitHole = oldWall.permitsHole();
        h.d_sawtooth = oldWall.isSawtoothed();
        h.d_thicken = oldWall.isThickened();
        return h;
    }

    protected IFace createFace(Wall wall, byte internalFaceIndex, Material mat) {
        return new AUnalignedFDSObject.BlockFace(wall, internalFaceIndex, mat);
    }

    @Override
    protected void imprint(Object baseObject) {
        if (!(baseObject instanceof Wall)) {
            return;
        }
        ADomainObject.pauseUpdates(this, false);
        super.imprint(baseObject);
        Wall obj = (Wall)baseObject;
        this.d_thicken = obj.d_thicken;
        this.d_permitHole = obj.d_permitHole;
        this.d_sawtooth = obj.d_sawtooth;
        this.resumeUpdates(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Wall b = (Wall)obj;
        boolean equal = this.d_thicken == b.d_thicken && this.d_permitHole == b.d_permitHole && this.d_sawtooth == b.d_sawtooth;
        return equal;
    }

    @Override
    public String getPropertyHashString() {
        Object s = super.getPropertyHashString();
        s = (String)s + this.d_permitHole + "," + this.d_thicken + "," + this.d_sawtooth + ";";
        return s;
    }

    @Override
    public boolean isSolid() {
        return true;
    }

    @Override
    protected IFDSFragGenerator getFaceFragGenerator(IFace face) {
        return new BlockFragGenerator(new AFDSFaceProps(face){

            @Override
            public boolean isThickened() {
                return Wall.this.isThickened();
            }

            @Override
            public boolean permitsHoles() {
                return Wall.this.permitsHole();
            }

            @Override
            public boolean isSawtoothed() {
                return Wall.this.isSawtoothed();
            }
        }, FDSRasterization.getCellPriority(false, true, this.permitsHole()));
    }

    @Override
    public IFDSFragGenerator getInteriorFragGenerator() {
        return null;
    }

    @Override
    public String getFDSType() {
        return "OBST";
    }

    @Override
    protected void fillExtraRecords(FDSInputRecord rec) {
        rec.setValue("PERMIT_HOLE", this.d_permitHole);
        rec.setValue("SAWTOOTH", this.d_sawtooth);
        rec.setValue("THICKEN", this.d_thicken);
    }

    public boolean permitsHole() {
        return this.d_permitHole;
    }

    public boolean isSawtoothed() {
        return this.d_sawtooth;
    }

    public boolean isThickened() {
        return this.d_thicken;
    }

    public void setPermitsHole(boolean hole) {
        this.d_permitHole = hole;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    public void setIsSawtoothed(boolean d_sawtooth) {
        this.d_sawtooth = d_sawtooth;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    public void setIsThickened(boolean d_thicken) {
        this.d_thicken = d_thicken;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public String getTypeDescription() {
        return "Wall";
    }
}

