/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.ActivationEvent;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class TimeActivationEvent
extends ADomainObject<PyroMod>
implements ActivationEvent,
Serializable {
    static final long serialVersionUID = 1L;
    private double d_dTimeCriteria;
    private static final Unit CRITERIAUNIT = SI.SECOND;
    private int d_iAction;

    public TimeActivationEvent(UnitDouble time, int action) {
        this.d_dTimeCriteria = time.getValue(CRITERIAUNIT);
        this.d_iAction = action;
    }

    @Override
    public void setCriteria(Object criteria) {
        this.d_dTimeCriteria = ((UnitDouble)criteria).getValue(CRITERIAUNIT);
    }

    @Override
    public Object getCriteria() {
        return new UnitDouble(this.d_dTimeCriteria, CRITERIAUNIT);
    }

    @Override
    public void setAction(int action) {
        this.d_iAction = action;
    }

    @Override
    public int getAction() {
        return this.d_iAction;
    }

    @Override
    public boolean isActivated(Object state) {
        UnitDouble udState = (UnitDouble)state;
        return udState.getValue(CRITERIAUNIT) >= this.d_dTimeCriteria;
    }

    @Override
    public int getEventType() {
        return 0;
    }

    @Override
    public Object clone() {
        TimeActivationEvent evt = new TimeActivationEvent(new UnitDouble(this.d_dTimeCriteria, CRITERIAUNIT), this.d_iAction);
        return evt;
    }

    @Override
    public boolean equals(Object obj2) {
        if (!(obj2 instanceof TimeActivationEvent)) {
            return false;
        }
        TimeActivationEvent evt2 = (TimeActivationEvent)obj2;
        return evt2.getEventType() == this.getEventType() && evt2.getAction() == this.getAction() && evt2.getCriteria().equals(this.getCriteria());
    }
}

