/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.PyroSimObjectInputStream;
import pyrosim.legacy_2006_2.UnitBox3D;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.ASetNameTask;
import pyrosim.legacy_2006_2.domain.DisplayablePointObject;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.ValueRange;

public class ThcpRecord
extends ADomainObject<PyroMod>
implements Serializable,
DisplayablePointObject,
IFDSRenderable,
IPyroObject {
    static final long serialVersionUID = 1L;
    public UnitPoint3D d_location = null;
    public String d_gasPhaseQuantity = null;
    public String d_label = null;
    public UnitDouble d_dtsam = null;
    private static final Hashtable<String, ValueRange> d_ranges;
    public transient UnitBox3D d_xb = null;
    public transient UnitDouble d_depth = null;
    public transient UnitDouble d_diameter = null;
    public transient UnitDouble d_emissivity = null;
    public transient Integer d_ior = null;
    public transient Integer d_kHigh = null;
    public transient Integer d_kLow = null;

    public static ValueRange getValueRange(String field) {
        return d_ranges.get(field);
    }

    public ThcpRecord() {
    }

    public ThcpRecord(UnitPoint3D loc, String quantity, String label, UnitDouble dtsam) {
        this();
        this.d_location = loc;
        this.d_gasPhaseQuantity = quantity;
        this.d_label = label;
        this.d_dtsam = dtsam;
    }

    @Override
    public Object clone() {
        UnitPoint3D loc = this.d_location != null ? (UnitPoint3D)this.d_location.clone() : null;
        UnitDouble dtsam = this.d_dtsam != null ? (UnitDouble)this.d_dtsam.clone() : null;
        return new ThcpRecord(loc, this.d_gasPhaseQuantity, this.d_label, dtsam);
    }

    private void setLabel(String label) {
        this.d_label = label;
        this.fireDomainEvent(new PyroDomainEvent(this, ThcpRecord.class, 5));
    }

    public Task taskSetLabel(String label) {
        return new ASetNameTask(label){

            @Override
            public void setName(String newName) {
                ThcpRecord.this.setLabel(newName);
            }

            @Override
            protected String getName() {
                return ThcpRecord.this.getLabel();
            }
        };
    }

    @Override
    public UnitPoint3D getLocation() {
        return this.d_location;
    }

    @Override
    public Color getColor() {
        return Color.yellow;
    }

    public String getGasPhaseQuantity() {
        return this.d_gasPhaseQuantity;
    }

    @Override
    public int getPointSize() {
        return 8;
    }

    public String getLabel() {
        return this.d_label;
    }

    public UnitDouble getDtsam() {
        return this.d_dtsam;
    }

    @Override
    public String getFDSType() {
        return "THCP";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> recs) {
        FDSInputRecord rec = new FDSInputRecord();
        rec.setType("THCP");
        Unit length = FdsSISystem.getInstance().getLengthUnit();
        Vector<Double> xyz = new Vector<Double>(3);
        xyz.add(this.d_location.x(length));
        xyz.add(this.d_location.y(length));
        xyz.add(this.d_location.z(length));
        rec.setValue("XYZ", xyz);
        String quantity = this.getGasPhaseQuantity();
        rec.setValue("QUANTITY", quantity);
        String label = this.getLabel();
        rec.setValue("LABEL", label);
        if (this.getDtsam() != null) {
            UnitDouble dtsam = this.getDtsam();
            Unit time = FdsSISystem.getInstance().getTimeUnit();
            rec.setValue("DTSAM", dtsam.getValue(time));
        }
        recs.add(rec);
    }

    public boolean isDuplicate(ThcpRecord rec) {
        if (rec.d_location == null || rec.d_gasPhaseQuantity == null) {
            return false;
        }
        return rec.d_location.equals(this.d_location) && rec.d_gasPhaseQuantity.equals(this.d_gasPhaseQuantity);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ThcpRecord) {
            ThcpRecord rec = (ThcpRecord)obj;
            boolean equal = rec.d_location.equals(this.d_location) && rec.d_gasPhaseQuantity.equals(this.d_gasPhaseQuantity) && rec.d_label.equals(this.d_label) && (this.d_dtsam == null ? rec.d_dtsam == null : this.d_dtsam.equals(rec.d_dtsam));
            return equal;
        }
        return false;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if ((!(stream instanceof PyroSimObjectInputStream) || stream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)stream).getVersion() < 13) && this.d_dtsam != null && !ThcpRecord.getValueRange("DTSAM").checkValue(this.d_dtsam)) {
            this.d_dtsam = null;
        }
    }

    @Override
    public String getTypeDescription() {
        return "Thermocouple";
    }

    static {
        FdsSISystem si = FdsSISystem.getInstance();
        d_ranges = new Hashtable(2);
        d_ranges.put("DTSAM", UnitDoubleValueRange.createCheckedMin(0.0, si.getTimeUnit(), false));
    }
}

