/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import pyrosim.legacy_2006_2.domain.AMakeUniqueNameTask;
import pyrosim.legacy_2006_2.domain.APyroDomainManager;
import pyrosim.legacy_2006_2.domain.APyroManAddTask;
import pyrosim.legacy_2006_2.domain.APyroManClearTask;
import pyrosim.legacy_2006_2.domain.APyroManReplaceTask;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.PyroCollection;
import pyrosim.legacy_2006_2.domain.ThcpRecord;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.util.EmptyTask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class ThcpList
extends APyroDomainManager<Integer, ThcpRecord>
implements Serializable {
    static final long serialVersionUID = 1L;
    private Vector<ThcpRecord> d_thcpList = new Vector();

    @Override
    public Collection<? extends ThcpRecord> toCollection() {
        return new PyroCollection<Integer, ThcpRecord>(this);
    }

    @Override
    public ThcpRecord get(Integer index) {
        return this.d_thcpList.elementAt(index);
    }

    @Override
    public int size() {
        return this.d_thcpList.size();
    }

    public ThcpRecord[] toArray() {
        return this.d_thcpList.toArray(new ThcpRecord[this.d_thcpList.size()]);
    }

    @Override
    protected boolean add(ThcpRecord newThcpRecord) {
        for (ThcpRecord rec : this.d_thcpList) {
            if (!rec.isDuplicate(newThcpRecord) && !rec.getLabel().equals(newThcpRecord.getLabel())) continue;
            return false;
        }
        super.add(newThcpRecord);
        this.d_thcpList.add(newThcpRecord);
        this.fireDomainEvent(new PyroDomainEvent<ThcpList, ThcpRecord>(this, newThcpRecord, ThcpRecord.class, 3));
        return true;
    }

    private boolean addAll(Collection<? extends ThcpRecord> objs) {
        this.pauseUpdates();
        boolean result = true;
        for (ThcpRecord thcpRecord : objs) {
            if (this.add(thcpRecord)) continue;
            result = false;
        }
        this.resumeUpdates();
        return result;
    }

    @Override
    protected boolean remove(ThcpRecord obj) {
        super.remove(obj);
        this.d_thcpList.remove(obj);
        this.fireDomainEvent(new PyroDomainEvent<ThcpList, ThcpRecord>(this, obj, ThcpRecord.class, 4));
        return true;
    }

    private boolean removeAll(Collection<? extends ThcpRecord> objs) {
        this.pauseUpdates();
        boolean result = true;
        for (ThcpRecord thcpRecord : objs) {
            if (this.remove(thcpRecord)) continue;
            result = false;
        }
        this.resumeUpdates();
        return result;
    }

    public ThcpRecord getDuplicate(ThcpRecord rec) {
        for (ThcpRecord rec2 : this.d_thcpList) {
            if (!rec.isDuplicate(rec2)) continue;
            return rec2;
        }
        return null;
    }

    public boolean containsDuplicate(ThcpRecord rec) {
        return this.getDuplicate(rec) != null;
    }

    @Override
    public ThcpRecord get(String key) {
        for (ThcpRecord rec : this.d_thcpList) {
            if (!rec.getLabel().equals(key)) continue;
            return rec;
        }
        return null;
    }

    @Override
    public boolean contains(String key) {
        return this.get(key) != null;
    }

    @Override
    public boolean contains(Integer key) {
        return key < this.d_thcpList.size() && key >= 0;
    }

    @Override
    public boolean isEmpty() {
        return this.d_thcpList.isEmpty();
    }

    public ThcpRecord[] toArray(ThcpRecord[] array) {
        return this.d_thcpList.toArray(array);
    }

    @Override
    public Iterator<ThcpRecord> iterator() {
        return this.d_thcpList.iterator();
    }

    @Override
    public Class<ThcpRecord> getVClass() {
        return ThcpRecord.class;
    }

    @Override
    public Class<Integer> getKClass() {
        return Integer.class;
    }

    @Override
    public boolean canMakeUnique(ThcpRecord pyroObject) {
        return !this.containsDuplicate(pyroObject);
    }

    @Override
    public String describeObject(ThcpRecord pyroObject) {
        return pyroObject.getLabel();
    }

    @Override
    public ThcpRecord get(ThcpRecord pyroObject) {
        ThcpRecord dup = this.getDuplicate(pyroObject);
        if (dup != null) {
            return dup;
        }
        return this.get(pyroObject.getLabel());
    }

    @Override
    public Task taskMakeUnique(ThcpRecord pyroObject) {
        if (this.containsDuplicate(pyroObject)) {
            return new EmptyTask();
        }
        return new AMakeUniqueNameTask<ThcpRecord>(this.getDomains(), pyroObject){

            @Override
            protected Task taskMakeUnique(ThcpRecord obj) {
                if (!ThcpList.this.contains(obj.getLabel())) {
                    return new EmptyTask();
                }
                int number = 1;
                String name = obj.getLabel() + " #" + number++;
                while (ThcpList.this.contains(name)) {
                    name = obj.getLabel() + " #" + number++;
                }
                return obj.taskSetLabel(name);
            }
        };
    }

    @Override
    public Task taskAddAll(Collection<? extends ThcpRecord> pyroObjects) {
        return new APyroManAddTask<Integer, ThcpRecord>((IPyroManager)this, pyroObjects){

            @Override
            public boolean add(ThcpRecord obj) {
                return ThcpList.this.add(obj);
            }

            @Override
            public boolean remove(ThcpRecord obj) {
                return ThcpList.this.remove(obj);
            }
        };
    }

    @Override
    public Task taskRemoveAll(List<ThcpRecord> pyroObjects, List<ThcpRecord> replacements) {
        return new APyroManReplaceTask<Integer, ThcpRecord>((IPyroManager)this, pyroObjects, replacements){

            @Override
            public boolean add(ThcpRecord obj) {
                return ThcpList.this.add(obj);
            }

            @Override
            public boolean remove(ThcpRecord obj) {
                return ThcpList.this.remove(obj);
            }
        };
    }

    public Task taskClear() {
        return new APyroManClearTask<Integer, ThcpRecord>((IPyroManager)this){

            @Override
            public void addAll(Collection<ThcpRecord> objs) {
                ThcpList.this.addAll(objs);
            }

            @Override
            public void removeAll(Collection<ThcpRecord> objs) {
                ThcpList.this.removeAll(objs);
            }
        };
    }
}

