/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.image.BufferedImage;
import java.io.Serializable;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.MaterialList;
import pyrosim.legacy_2006_2.domain.TextureInfo;

public class Texture
implements Serializable {
    static final long serialVersionUID = 1L;
    private final String d_texName;
    private transient BufferedImage d_natImage;

    public Texture(String texName, BufferedImage img) {
        this.d_texName = texName;
        this.d_natImage = img;
    }

    public String getImageID() {
        return this.d_texName;
    }

    public boolean isValid() {
        return true;
    }

    public boolean isHeavy() {
        return this.d_natImage != null;
    }

    public BufferedImage getImage() {
        return this.d_natImage;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof Texture) {
            return ((Texture)o).getImageID().equals(this.getImageID());
        }
        return false;
    }

    public int hashCode() {
        return this.getImageID().hashCode();
    }

    public boolean usedIn(PyroMod mod) {
        MaterialList mats = mod.getMaterials();
        for (Material mat : mats) {
            TextureInfo texInfo = mat.getTextureInfo();
            if (texInfo == null || !texInfo.getTexID().equals(this.getImageID())) continue;
            return true;
        }
        return false;
    }
}

