/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JList;
import pyrosim.io.IOUtil;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.AMakeUniqueNameTask;
import pyrosim.legacy_2006_2.domain.APyroDomainManager;
import pyrosim.legacy_2006_2.domain.APyroManAddTask;
import pyrosim.legacy_2006_2.domain.APyroManClearTask;
import pyrosim.legacy_2006_2.domain.APyroManReplaceTask;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.PyroCollection;
import pyrosim.legacy_2006_2.domain.SprkRecord;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class SprkList
extends APyroDomainManager<String, SprkRecord>
implements Serializable,
Cloneable,
IPyroManager<String, SprkRecord> {
    static final long serialVersionUID = 1L;
    private Vector<SprkRecord> d_sprkList = new Vector();

    @Override
    public Collection<? extends SprkRecord> toCollection() {
        return new PyroCollection<String, SprkRecord>(this);
    }

    @Override
    public Object clone() {
        SprkList temp = new SprkList();
        for (int i = 0; i < this.d_sprkList.size(); ++i) {
            SprkRecord tempRec = this.d_sprkList.elementAt(i);
            temp.d_sprkList.add((SprkRecord)tempRec.clone());
        }
        return temp;
    }

    @Override
    public SprkRecord get(int index) {
        return this.d_sprkList.elementAt(index);
    }

    @Override
    public SprkRecord get(String label) {
        for (int m = 0; m < this.d_sprkList.size(); ++m) {
            SprkRecord r = this.d_sprkList.get(m);
            if (!r.getLabel().equals(label)) continue;
            return r;
        }
        return null;
    }

    @Override
    public boolean contains(String label) {
        for (int m = 0; m < this.d_sprkList.size(); ++m) {
            SprkRecord r = this.d_sprkList.get(m);
            if (!r.getLabel().equals(label)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.d_sprkList.size();
    }

    public SprkRecord[] toArray() {
        return this.d_sprkList.toArray(new SprkRecord[this.d_sprkList.size()]);
    }

    @Override
    protected boolean add(SprkRecord newSprkRecord) {
        SprkRecord old = this.get(newSprkRecord.getLabel());
        if (old != null) {
            return false;
        }
        super.add(newSprkRecord);
        boolean result = this.d_sprkList.add(newSprkRecord);
        this.fireDomainEvent(new PyroDomainEvent<SprkList, SprkRecord>(this, newSprkRecord, SprkRecord.class, 3));
        return result;
    }

    private boolean addAll(Collection<? extends SprkRecord> objs) {
        this.pauseUpdates();
        boolean result = true;
        for (SprkRecord sprkRecord : objs) {
            if (this.add(sprkRecord)) continue;
            result = false;
        }
        this.resumeUpdates();
        return result;
    }

    public JList getAllLabels() {
        JList allLabels;
        Vector<String> v = new Vector<String>();
        if (this.size() != 0) {
            for (int i = 0; i < this.size(); ++i) {
                v.add(this.get(i).getLabel());
            }
            allLabels = new JList(v);
        } else {
            allLabels = new JList();
        }
        return allLabels;
    }

    public Vector getAllNames() {
        Vector<String> names = new Vector<String>();
        if (this.size() != 0) {
            for (int i = 0; i < this.size(); ++i) {
                names.add(this.get(i).getLabel());
            }
        }
        return names;
    }

    @Override
    protected boolean remove(SprkRecord rec) {
        boolean result = this.d_sprkList.remove(rec);
        super.remove(rec);
        this.fireDomainEvent(new PyroDomainEvent<SprkList, SprkRecord>(this, rec, SprkRecord.class, 4));
        return result;
    }

    private boolean removeAll(Collection<? extends SprkRecord> objs) {
        this.pauseUpdates();
        boolean result = true;
        for (SprkRecord sprkRecord : objs) {
            if (this.remove(sprkRecord)) continue;
            result = false;
        }
        this.resumeUpdates();
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.d_sprkList.isEmpty();
    }

    public SprkRecord[] toArray(SprkRecord[] array) {
        return this.d_sprkList.toArray(array);
    }

    @Override
    public Iterator<SprkRecord> iterator() {
        return this.d_sprkList.iterator();
    }

    @Override
    public Class<SprkRecord> getVClass() {
        return SprkRecord.class;
    }

    @Override
    public Class<String> getKClass() {
        return String.class;
    }

    @Override
    public boolean canMakeUnique(SprkRecord pyroObject) {
        return true;
    }

    @Override
    public Task taskMakeUnique(SprkRecord pyroObject) {
        return new AMakeUniqueNameTask<SprkRecord>(this.getDomains(), pyroObject){

            @Override
            protected Task taskMakeUnique(SprkRecord obj) {
                return obj.taskSetName(APyroDomainManager.getUniqueName(SprkList.this, obj.getLabel()));
            }
        };
    }

    public static String[] getAvailable(PyroMod pyMod) {
        File sprkDir = pyMod.getDBDir();
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("spk");
            }
        };
        List<String> names = IOUtil.listFilenames(sprkDir, filter);
        for (int i = 0; i < names.size(); ++i) {
            names.set(i, names.get(i).substring(0, names.get(i).lastIndexOf(46)));
        }
        return theUtil.toArray(names, String.class);
    }

    @Override
    public String describeObject(SprkRecord pyroObject) {
        return pyroObject.getLabel();
    }

    @Override
    public SprkRecord get(SprkRecord pyroObject) {
        return this.get(pyroObject.getLabel());
    }

    @Override
    public Task taskAddAll(Collection<? extends SprkRecord> pyroObjects) {
        return new APyroManAddTask<String, SprkRecord>((IPyroManager)this, pyroObjects){

            @Override
            public boolean add(SprkRecord obj) {
                return SprkList.this.add(obj);
            }

            @Override
            public boolean remove(SprkRecord obj) {
                return SprkList.this.remove(obj);
            }
        };
    }

    @Override
    public Task taskRemoveAll(List<SprkRecord> pyroObjects, List<SprkRecord> replacements) {
        return new APyroManReplaceTask<String, SprkRecord>((IPyroManager)this, pyroObjects, replacements){

            @Override
            public boolean add(SprkRecord obj) {
                return SprkList.this.add(obj);
            }

            @Override
            public boolean remove(SprkRecord obj) {
                return SprkList.this.remove(obj);
            }
        };
    }

    public Task taskClear() {
        return new APyroManClearTask<String, SprkRecord>((IPyroManager)this){

            @Override
            public void addAll(Collection<SprkRecord> objs) {
                SprkList.this.addAll(objs);
            }

            @Override
            public void removeAll(Collection<SprkRecord> objs) {
                SprkList.this.removeAll(objs);
            }
        };
    }
}

