/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.Hashtable;
import pyrosim.legacy_2006_2.domain.BNDFRecord;
import pyrosim.legacy_2006_2.domain.SolidPhaseQuantity;
import pyrosim.legacy_2006_2.domain.SolidPhaseQuantityParam;
import pyrosim.legacy_2006_2.io.FDSInputRecord;

public class SolidPhaseQuantitiesList {
    private static Hashtable d_htQuantities = new Hashtable(10);
    public static SolidPhaseQuantity RADIATIVE_FLUX = new SolidPhaseQuantity("RADIATIVE_FLUX", "Net radiative flux");
    public static SolidPhaseQuantity CONVECTIVE_FLUX = new SolidPhaseQuantity("CONVECTIVE_FLUX", "Convective flux");
    public static SolidPhaseQuantity HEAT_FLUX = new SolidPhaseQuantity("HEAT_FLUX", "Net heat flux");
    public static SolidPhaseQuantity GAUGE_HEAT_FLUX = new SolidPhaseQuantity("GAUGE_HEAT_FLUX", "Equivalent heat flux to cold wall");
    public static SolidPhaseQuantity INCIDENT_HEAT_FLUX = new SolidPhaseQuantity("INCIDENT_HEAT_FLUX", "Incident heat flux");
    public static SolidPhaseQuantity WALL_TEMPERATURE = new SolidPhaseQuantity("WALL_TEMPERATURE", "Wall temperature");
    public static SolidPhaseQuantity INSIDE_WALL_TEMPERATURE = new SolidPhaseQuantity("INSIDE_WALL_TEMPERATURE", "Inner wall temperature");
    public static SolidPhaseQuantity BURNING_RATE = new SolidPhaseQuantity("BURNING_RATE", "Mass loss rate per unit area");
    public static SolidPhaseQuantity PRESSURE_COEFFICIENT = new SolidPhaseQuantity("PRESSURE_COEFFICIENT", "Pressure coefficient");
    public static SolidPhaseQuantity WMPUA = new SolidPhaseQuantity("WMPUA", "Water Mass Per Unit Area");
    public static SolidPhaseQuantity WCPUA = new SolidPhaseQuantity("WCPUA", "Water Cooling Per Unit Area");

    public SolidPhaseQuantity[] getAllQuantities() {
        return d_htQuantities.values().toArray(new SolidPhaseQuantity[d_htQuantities.size()]);
    }

    public boolean contains(String quantityName) {
        return d_htQuantities.get(quantityName) != null;
    }

    static {
        INSIDE_WALL_TEMPERATURE.addParam(new SolidPhaseQuantityParam("DEPTH", "Depth", "Distance in wall", 0, BNDFRecord.DEF_DEPTH));
        PRESSURE_COEFFICIENT.addParam(new SolidPhaseQuantityParam("CHARACTERISTIC_VELOCITY", "Velocity", "Characteristic velocity, U", 8, FDSInputRecord.DEF_CHARACTERISTIC_VELOCITY));
        GAUGE_HEAT_FLUX.addParam(new SolidPhaseQuantityParam("GAUGE_TEMPERATURE", "Temperature", "Guage Temperature", 1, FDSInputRecord.DEF_GAUGE_TEMPERATURE));
        d_htQuantities.put(RADIATIVE_FLUX.getName(), RADIATIVE_FLUX);
        d_htQuantities.put(CONVECTIVE_FLUX.getName(), CONVECTIVE_FLUX);
        d_htQuantities.put(HEAT_FLUX.getName(), HEAT_FLUX);
        d_htQuantities.put(GAUGE_HEAT_FLUX.getName(), GAUGE_HEAT_FLUX);
        d_htQuantities.put(INCIDENT_HEAT_FLUX.getName(), INCIDENT_HEAT_FLUX);
        d_htQuantities.put(WALL_TEMPERATURE.getName(), WALL_TEMPERATURE);
        d_htQuantities.put(INSIDE_WALL_TEMPERATURE.getName(), INSIDE_WALL_TEMPERATURE);
        d_htQuantities.put(BURNING_RATE.getName(), BURNING_RATE);
        d_htQuantities.put(PRESSURE_COEFFICIENT.getName(), PRESSURE_COEFFICIENT);
        d_htQuantities.put(WMPUA.getName(), WMPUA);
        d_htQuantities.put(WCPUA.getName(), WCPUA);
    }
}

