/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.Color;
import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.APyroDomainManager;
import pyrosim.legacy_2006_2.domain.DisplayablePointObject;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.SmodList;
import pyrosim.legacy_2006_2.domain.dependencies.AChangePyroDepOnIDTask;
import pyrosim.legacy_2006_2.domain.dependencies.AChangePyroDepOnTask;
import pyrosim.legacy_2006_2.domain.dependencies.IPyroDependedOn;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.gui.IDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public class SmodRecord
extends ADomainObject<PyroMod>
implements Serializable,
DisplayablePointObject,
IPyroDependedOn,
IFDSRenderable {
    static final long serialVersionUID = 1L;
    private UnitPoint3D d_pLocation;
    private UnitDouble d_actObscure;
    private String d_label;
    public static final int TYPE_HESKESTAD = 0;
    public static final int TYPE_CLEARY = 1;
    private int d_type;
    private UnitDouble d_hLength;
    private UnitDouble d_cAlphaC;
    private UnitDouble d_cBetaC;
    private UnitDouble d_cAlphaE;
    private UnitDouble d_cBetaE;

    public SmodRecord(SmodList smList) {
        FdsSISystem uSys = FdsSISystem.getInstance();
        this.d_pLocation = new UnitPoint3D(0.0, 0.0, 0.0, uSys.getLengthUnit());
        this.d_label = APyroDomainManager.getUniqueName(smList, "SMOD");
        this.d_actObscure = new UnitDouble(1.0, uSys.getObscurationUnit());
        this.d_type = 0;
        this.d_hLength = new UnitDouble(1.8, SI.METER);
        this.d_cAlphaC = new UnitDouble(0.8, uSys.getUnitlessUnit());
        this.d_cBetaC = new UnitDouble(-0.9, uSys.getUnitlessUnit());
        this.d_cAlphaE = new UnitDouble(2.5, uSys.getUnitlessUnit());
        this.d_cBetaE = new UnitDouble(-0.7, uSys.getUnitlessUnit());
    }

    public String getLabel() {
        return this.getUniqueID();
    }

    @Override
    public UnitPoint3D getLocation() {
        return this.d_pLocation;
    }

    @Override
    public Color getColor() {
        return Color.white;
    }

    @Override
    public int getPointSize() {
        return 8;
    }

    @Override
    public String getUniqueID() {
        return this.d_label;
    }

    @Override
    public String getTypeDescription() {
        return "Smoke Detector";
    }

    @Override
    public Object getUniqueTypeKey() {
        return this.getFDSType();
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> recs) {
        recs.add(this.toRecord());
    }

    public FDSInputRecord toRecord() {
        FDSInputRecord record = new FDSInputRecord();
        record.setType("SMOD");
        FdsSISystem us = FdsSISystem.getInstance();
        Vector<Double> location = new Vector<Double>(3);
        location.add(this.d_pLocation.x(us.getLengthUnit()));
        location.add(this.d_pLocation.y(us.getLengthUnit()));
        location.add(this.d_pLocation.z(us.getLengthUnit()));
        record.setValue("XYZ", location);
        assert (this.d_type == 0 || this.d_type == 1);
        if (this.d_type == 0) {
            record.setValue("LENGTH", this.d_hLength.getValue(us.getLengthUnit()));
        } else if (this.d_type == 1) {
            record.setValue("ALPHA_C", this.d_cAlphaC.getValue(us.getUnitlessUnit()));
            record.setValue("BETA_C", this.d_cBetaC.getValue(us.getUnitlessUnit()));
            record.setValue("ALPHA_E", this.d_cAlphaE.getValue(us.getUnitlessUnit()));
            record.setValue("BETA_E", this.d_cBetaE.getValue(us.getUnitlessUnit()));
        }
        record.setValue("ACTIVATION_OBSCURATION", this.d_actObscure.getValue(us.getObscurationUnit()));
        record.setValue("LABEL", this.d_label);
        return record;
    }

    @Override
    public String getFDSType() {
        return "SMOD";
    }

    public boolean fireDomainEvent(IDomainEvent event, boolean updateDependents) {
        this.pauseUpdates();
        boolean fired = super.fireDomainEvent(event);
        if (updateDependents) {
            new AChangePyroDepOnTask(this, this.getDomains()).run();
        }
        this.resumeUpdates();
        return fired;
    }

    private void changed() {
        this.fireDomainEvent(new PyroDomainEvent(this, SmodRecord.class, 5), false);
    }

    public void setLabel(String newID) {
        this.d_label = newID;
        this.changed();
    }

    public void setLocation(UnitPoint3D pt) {
        this.d_pLocation = pt;
        this.changed();
    }

    public void setHLength(UnitDouble len) {
        this.d_hLength = len;
        this.changed();
    }

    public void setCAlphaC(UnitDouble val) {
        this.d_cAlphaC = val;
        this.changed();
    }

    public void setCBetaC(UnitDouble val) {
        this.d_cBetaC = val;
        this.changed();
    }

    public void setCAlphaE(UnitDouble val) {
        this.d_cAlphaE = val;
        this.changed();
    }

    public void setCBetaE(UnitDouble val) {
        this.d_cBetaE = val;
        this.changed();
    }

    public void setObscuration(UnitDouble val) {
        this.d_actObscure = val;
        this.changed();
    }

    public UnitDouble getObscuration() {
        return this.d_actObscure;
    }

    public void setType(int type) {
        this.d_type = type;
        this.changed();
    }

    public int getType() {
        return this.d_type;
    }

    public UnitDouble getLength() {
        return this.d_hLength;
    }

    public UnitDouble getCAlphaC() {
        return this.d_cAlphaC;
    }

    public UnitDouble getCBetaC() {
        return this.d_cBetaC;
    }

    public UnitDouble getCAlphaE() {
        return this.d_cAlphaE;
    }

    public UnitDouble getCBetaE() {
        return this.d_cBetaE;
    }

    public Task taskSetLabel(String label) {
        return new AChangePyroDepOnIDTask(this, label, this.getDomains()){

            @Override
            public void setID(String newID) {
                SmodRecord.this.setLabel(newID);
            }
        };
    }
}

