/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.PyroSimObjectInputStream;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.ValueRange;

public class SlcfRecord
extends ADomainObject<PyroMod>
implements Serializable,
IFDSRenderable,
IPyroObject {
    static final long serialVersionUID = 1L;
    private String d_xyzPlane;
    private UnitDouble d_udXYZValue;
    private String d_gasPhaseQuantity;
    private boolean d_useVector;
    private UnitDouble d_dtsam;
    private static final Hashtable<String, ValueRange> d_ranges;

    public static ValueRange getValueRange(String field) {
        return d_ranges.get(field);
    }

    public SlcfRecord(String plane, UnitDouble value, String quantity, boolean v, UnitDouble dtsam) {
        this.d_xyzPlane = plane;
        this.d_udXYZValue = value;
        this.d_gasPhaseQuantity = quantity;
        this.d_useVector = v;
        this.d_dtsam = dtsam;
    }

    @Override
    public Object clone() {
        SlcfRecord clone = (SlcfRecord)super.clone();
        clone.d_dtsam = this.d_dtsam != null ? (UnitDouble)this.d_dtsam.clone() : null;
        clone.d_udXYZValue = this.d_udXYZValue != null ? (UnitDouble)this.d_udXYZValue.clone() : null;
        return clone;
    }

    public String getPlane() {
        return this.d_xyzPlane;
    }

    public UnitDouble getValue() {
        return this.d_udXYZValue;
    }

    public String getGasPhaseQuantity() {
        return this.d_gasPhaseQuantity;
    }

    public boolean getUseVector() {
        return this.d_useVector;
    }

    public UnitDouble getDtsam() {
        return this.d_dtsam;
    }

    @Override
    public String getFDSType() {
        return "SLCF";
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> recs) {
        UnitDouble dtsam;
        FDSInputRecord rec = new FDSInputRecord();
        rec.setType("SLCF");
        rec.setValue(this.getPlane(), this.getValue().getValue(FdsSISystem.getInstance().getLengthUnit()));
        String quantity = this.getGasPhaseQuantity();
        rec.setValue("QUANTITY", quantity);
        if (this.getUseVector()) {
            rec.setValue("VECTOR", Boolean.TRUE);
        }
        if ((dtsam = this.getDtsam()) != null) {
            Unit time = FdsSISystem.getInstance().getTimeUnit();
            rec.setValue("DTSAM", dtsam.getValue(time));
        }
        recs.add(rec);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SlcfRecord) {
            SlcfRecord rec = (SlcfRecord)obj;
            return rec.d_xyzPlane.equals(this.d_xyzPlane) && rec.d_udXYZValue.equals(this.d_udXYZValue) && rec.d_gasPhaseQuantity.equals(this.d_gasPhaseQuantity) && rec.d_useVector == this.d_useVector && (this.d_dtsam == null ? rec.d_dtsam == null : this.d_dtsam.equals(rec.d_dtsam));
        }
        return false;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gf = stream.readFields();
        this.d_xyzPlane = (String)gf.get("d_xyzPlane", null);
        this.d_udXYZValue = (UnitDouble)gf.get("d_udXYZValue", null);
        this.d_gasPhaseQuantity = (String)gf.get("d_gasPhaseQuantity", null);
        this.d_useVector = gf.get("d_useVector", false);
        if (this.d_udXYZValue == null) {
            double xyzValue = gf.get("d_xyzValue", 0.0);
            this.d_udXYZValue = new UnitDouble(xyzValue, SI.METER);
        }
        if ((!(stream instanceof PyroSimObjectInputStream) || stream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)stream).getVersion() < 13) && this.d_dtsam != null && !SlcfRecord.getValueRange("DTSAM").checkValue(this.d_dtsam)) {
            this.d_dtsam = null;
        }
    }

    @Override
    public String getTypeDescription() {
        return "Planar Slice";
    }

    static {
        FdsSISystem si = FdsSISystem.getInstance();
        d_ranges = new Hashtable(2);
        d_ranges.put("DTSAM", UnitDoubleValueRange.createCheckedMin(0.0, si.getTimeUnit(), false));
    }
}

